/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.reverseengineering.gast2seff.visitors;

import de.fzi.gast.accesses.Access;
import de.fzi.gast.accesses.FunctionAccess;
import de.fzi.gast.statements.BlockStatement;
import de.fzi.gast.statements.Branch;
import de.fzi.gast.statements.BranchStatement;
import de.fzi.gast.statements.LoopStatement;
import de.fzi.gast.statements.SimpleStatement;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.statements.util.statementsSwitch;
import eu.qimpress.reverseengineering.gast2seff.jobs.GAST2SEFFJob;
import eu.qimpress.reverseengineering.gast2seff.visitors.FunctionCallClassificationVisitor;
import eu.qimpress.seff.BranchAction;
import eu.qimpress.seff.ExternalCallAction;
import eu.qimpress.seff.InternalAction;
import eu.qimpress.seff.LoopAction;
import eu.qimpress.seff.ProbabilisticBranchTransition;
import eu.qimpress.seff.ResourceDemandingBehaviour;
import eu.qimpress.seff.seffFactory;
import java.util.BitSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class GastStatementVisitor
extends statementsSwitch<Object> {
    private static final Logger logger = Logger.getLogger(GastStatementVisitor.class);
    private ResourceDemandingBehaviour seff;
    private Map<Statement, BitSet> functionClassificationAnnotation;
    private BitSet lastType = null;

    public GastStatementVisitor(Map<Statement, BitSet> functionClassificationAnnotations, ResourceDemandingBehaviour resourceDemandingBehaviour) {
        this.seff = resourceDemandingBehaviour;
        this.functionClassificationAnnotation = functionClassificationAnnotations;
    }

    public Object caseBlockStatement(BlockStatement object) {
        for (Statement s : object.getStatements()) {
            BitSet thisType = this.functionClassificationAnnotation.get(s);
            if (!this.shouldSkip(this.lastType, thisType)) {
                this.doSwitch((EObject)s);
            }
            this.lastType = thisType;
        }
        return null;
    }

    public Object caseBranchStatement(BranchStatement object) {
        if (this.containsExternalCall((Statement)object)) {
            BranchAction branch = seffFactory.eINSTANCE.createBranchAction();
            this.seff.getSteps().add((Object)branch);
            for (Branch b : object.getBranches()) {
                ProbabilisticBranchTransition bt = seffFactory.eINSTANCE.createProbabilisticBranchTransition();
                bt.setResourceDemandingBehaviour(seffFactory.eINSTANCE.createResourceDemandingBehaviour());
                branch.getAbstractBranchTransition().add((Object)bt);
                GastStatementVisitor visitor = new GastStatementVisitor(this.functionClassificationAnnotation, bt.getResourceDemandingBehaviour());
                Statement s = b.getStatement();
                visitor.doSwitch((EObject)s);
                GAST2SEFFJob.connectActions(bt.getResourceDemandingBehaviour());
            }
        } else {
            this.createInternalAction();
        }
        return null;
    }

    public Object caseLoopStatement(LoopStatement object) {
        if (this.containsExternalCall((Statement)object)) {
            LoopAction loop = seffFactory.eINSTANCE.createLoopAction();
            loop.setBodyBehaviour(seffFactory.eINSTANCE.createResourceDemandingBehaviour());
            this.seff.getSteps().add((Object)loop);
            new GastStatementVisitor(this.functionClassificationAnnotation, loop.getBodyBehaviour()).doSwitch((EObject)object.getBody());
            GAST2SEFFJob.connectActions(loop.getBodyBehaviour());
        } else {
            this.createInternalAction();
        }
        return null;
    }

    public Object caseSimpleStatement(SimpleStatement object) {
        BitSet statementAnnotation = this.functionClassificationAnnotation.get(object);
        if (this.isExternalCall(statementAnnotation)) {
            this.createExternalCallAction(object);
        } else if (this.isInternalCall(statementAnnotation)) {
            FunctionAccess functionAccess = this.getFunctionAccess(object);
            BlockStatement body = functionAccess.getTargetFunction().getBody();
            if (body != null) {
                this.doSwitch((EObject)body);
            } else {
                logger.warn((Object)("Behaviour not set in GAST for " + functionAccess.getTargetFunction().getSimpleName()));
            }
        } else {
            this.createInternalAction();
        }
        return null;
    }

    private boolean shouldSkip(BitSet lastType, BitSet thisType) {
        if (lastType == null) {
            return false;
        }
        if (this.isExternalCall(thisType)) {
            return false;
        }
        return !this.isExternalCall(lastType);
    }

    private void createExternalCallAction(SimpleStatement object) {
        ExternalCallAction call = seffFactory.eINSTANCE.createExternalCallAction();
        FunctionAccess access = this.getFunctionAccess(object);
        call.setName(access.getTargetFunction().getSimpleName());
        this.seff.getSteps().add((Object)call);
    }

    private boolean isExternalCall(BitSet statementAnnotation) {
        return statementAnnotation.get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.EXTERNAL));
    }

    private boolean isInternalCall(BitSet statementAnnotation) {
        return statementAnnotation.get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.INTERNAL));
    }

    private FunctionAccess getFunctionAccess(SimpleStatement object) {
        for (Access a : object.getAccesses()) {
            if (!(a instanceof FunctionAccess)) continue;
            return (FunctionAccess)a;
        }
        return null;
    }

    private void createInternalAction() {
        InternalAction ia = seffFactory.eINSTANCE.createInternalAction();
        this.seff.getSteps().add((Object)ia);
    }

    private boolean containsExternalCall(Statement object) {
        return this.functionClassificationAnnotation.get(object).get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.EXTERNAL));
    }
}

