/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.reverseengineering.gast2seff.visitors;

import de.fzi.gast.accesses.FunctionAccess;
import de.fzi.gast.types.GASTClass;
import eu.qimpress.reverseengineering.gast2seff.visitors.AbstractFunctionClassificationStrategy;
import eu.qimpress.reverseengineering.gast2seff.visitors.IFunctionClassificationStrategy;
import org.apache.log4j.Logger;

public class BasicFunctionClassificationStrategy
extends AbstractFunctionClassificationStrategy
implements IFunctionClassificationStrategy {
    private static Logger logger = Logger.getLogger(BasicFunctionClassificationStrategy.class);

    @Override
    protected boolean isInternalCall(FunctionAccess functionAccess) {
        GASTClass hostingClass = this.findHostingClass(functionAccess.getSurroundingStatement());
        if (hostingClass != null && functionAccess.getAccessedClass() == hostingClass) {
            logger.debug((Object)("Classified call as internal call: " + functionAccess.getTargetFunction().getSimpleName()));
            return true;
        }
        return false;
    }

    @Override
    protected boolean isLibraryCall(FunctionAccess functionAccess) {
        GASTClass targetClass = functionAccess.getAccessedClass();
        if (targetClass == null) {
            logger.warn((Object)"Failed to classifiy library call because called GASTClass was unavailable.");
            return true;
        }
        return targetClass.getPosition().getSourceFile() == null;
    }
}

