/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.reverseengineering.gast2seff.jobs;

import de.fzi.gast.statements.BlockStatement;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import eu.qimpress.qimpressgast.GASTBehaviour;
import eu.qimpress.qimpressgast.GASTBehaviourRepository;
import eu.qimpress.reverseengineering.gast2seff.visitors.BasicFunctionClassificationStrategy;
import eu.qimpress.reverseengineering.gast2seff.visitors.FunctionCallClassificationVisitor;
import eu.qimpress.reverseengineering.gast2seff.visitors.GastStatementVisitor;
import eu.qimpress.samm.behaviour.Behaviour;
import eu.qimpress.samm.behaviour.BehaviourFactory;
import eu.qimpress.samm.behaviour.GastBehaviourStub;
import eu.qimpress.samm.behaviour.SeffBehaviourStub;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.seff.AbstractAction;
import eu.qimpress.seff.ResourceDemandingBehaviour;
import eu.qimpress.seff.ResourceDemandingSEFF;
import eu.qimpress.seff.SeffRepository;
import eu.qimpress.seff.StartAction;
import eu.qimpress.seff.StopAction;
import eu.qimpress.seff.seffFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;

public class GAST2SEFFJob
implements IJob {
    private Logger logger = Logger.getLogger(GAST2SEFFJob.class);
    private ResourceSet resourceSet = new ResourceSetImpl();
    private Resource sammInstance = null;
    private Resource gastBehaviourRepository = null;
    private Resource seffBehaviourRepository = null;
    private static final String SEFF_BEHAVIOUR_EXTENSION = "samm_seff";
    private static final String GAST_BEHAVIOUR_EXTENSION = "samm_gastbehaviour";
    private FunctionCallClassificationVisitor typeVisitor = new FunctionCallClassificationVisitor(new BasicFunctionClassificationStrategy());
    private URI sammInstanceURI;
    private URI gastBehaviourRepositoryURI;
    private URI seffBehaviourRepositoryURI;

    public GAST2SEFFJob(URI sammInstanceURI) {
        this(sammInstanceURI, sammInstanceURI.trimFileExtension().appendFileExtension(GAST_BEHAVIOUR_EXTENSION), sammInstanceURI.trimFileExtension().appendFileExtension(SEFF_BEHAVIOUR_EXTENSION));
    }

    public GAST2SEFFJob(URI sammInstanceURI, URI gastBehaviourRepositoryURI, URI seffBehaviourRepositoryURI) {
        this.sammInstanceURI = sammInstanceURI;
        this.gastBehaviourRepositoryURI = gastBehaviourRepositoryURI;
        this.seffBehaviourRepositoryURI = seffBehaviourRepositoryURI;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        this.sammInstance = this.loadResource(this.sammInstanceURI);
        this.gastBehaviourRepository = this.loadResource(this.gastBehaviourRepositoryURI);
        this.seffBehaviourRepository = this.createResource(this.seffBehaviourRepositoryURI);
        SeffRepository seffRepository = seffFactory.eINSTANCE.createSeffRepository();
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, -1);
        TreeIterator iterator = this.sammInstance.getAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof GastBehaviourStub)) continue;
            this.logger.info((Object)"Found GAST behaviour, generating SEFF behaviour for it");
            ResourceDemandingSEFF resourceDemandingSEFF = this.generateSEFFForGASTBehaviour((GastBehaviourStub)eObject);
            seffRepository.getResourceDemandingSeff().add((Object)resourceDemandingSEFF);
            monitor.worked(1);
        }
        subMonitor.done();
        this.seffBehaviourRepository.getContents().add((Object)seffRepository);
        this.saveResource(this.seffBehaviourRepository);
        this.saveResource(this.sammInstance);
    }

    public String getName() {
        return "GAST2SEFF Transformation Job";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    private Resource loadResource(URI uri) throws JobFailedException {
        Resource resource = this.resourceSet.createResource(uri);
        Map loadOptions = ((XMLResourceImpl)resource).getDefaultLoadOptions();
        loadOptions.put("DEFER_ATTACHMENT", Boolean.TRUE);
        loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        loadOptions.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
        loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl());
        loadOptions.put("USE_XML_NAME_TO_FEATURE_MAP", new HashMap());
        try {
            resource.load(loadOptions);
        }
        catch (IOException e) {
            throw new JobFailedException("Loading of a required resource failed", (Throwable)e);
        }
        return resource;
    }

    private Resource createResource(URI uri) {
        Resource resource = this.resourceSet.createResource(uri);
        return resource;
    }

    private void saveResource(Resource resource) throws JobFailedException {
        try {
            resource.save(new HashMap());
        }
        catch (IOException e) {
            throw new JobFailedException("Saving model output failed", (Throwable)e);
        }
    }

    private ResourceDemandingSEFF createSeff(GastBehaviourStub gastBehaviourStub, ResourceDemandingSEFF seff) throws JobFailedException {
        StartAction start = seffFactory.eINSTANCE.createStartAction();
        StopAction stop = seffFactory.eINSTANCE.createStopAction();
        seff.getSteps().add((Object)start);
        BlockStatement body = this.findBody(gastBehaviourStub);
        if (body != null) {
            this.typeVisitor.doSwitch((EObject)body);
            GastStatementVisitor visitor = new GastStatementVisitor(this.typeVisitor.getAnnotations(), (ResourceDemandingBehaviour)seff);
            visitor.doSwitch((EObject)body);
        } else {
            this.logger.warn((Object)"Found GAST behaviour without a method body... Skiping it...");
        }
        seff.getSteps().add((Object)stop);
        GAST2SEFFJob.connectActions((ResourceDemandingBehaviour)seff);
        return seff;
    }

    private BlockStatement findBody(GastBehaviourStub gastBehaviourStub) throws JobFailedException {
        GASTBehaviourRepository gastBehaviourRepository = (GASTBehaviourRepository)this.gastBehaviourRepository.getContents().get(0);
        for (GASTBehaviour behaviour : gastBehaviourRepository.getGastbehaviour()) {
            if (behaviour.getGastbehaviourstub() != gastBehaviourStub) continue;
            return behaviour.getBlockstatement();
        }
        throw new JobFailedException("Unable to find operation body for given method");
    }

    public static void connectActions(ResourceDemandingBehaviour seff) {
        AbstractAction previous = null;
        for (AbstractAction a : seff.getSteps()) {
            a.setPredecessor_AbstractAction(previous);
            previous = a;
        }
    }

    private ResourceDemandingSEFF generateSEFFForGASTBehaviour(GastBehaviourStub gastBehaviourStub) throws JobFailedException {
        ResourceDemandingSEFF resourceDemandingSEFF = seffFactory.eINSTANCE.createResourceDemandingSEFF();
        this.createSeff(gastBehaviourStub, resourceDemandingSEFF);
        SeffBehaviourStub seffBehaviourStub = this.findOrCreateBehaviourStub(gastBehaviourStub);
        resourceDemandingSEFF.setSeffBehaviourStub(seffBehaviourStub);
        return resourceDemandingSEFF;
    }

    private SeffBehaviourStub findOrCreateBehaviourStub(GastBehaviourStub gastBehaviourStub) {
        PrimitiveComponent parentComponent = (PrimitiveComponent)gastBehaviourStub.eContainer();
        SeffBehaviourStub seffBehaviourStub = null;
        for (Behaviour behaviour : parentComponent.getOperationBehaviour()) {
            SeffBehaviourStub candidateStub;
            if (!(behaviour instanceof SeffBehaviourStub) || (candidateStub = (SeffBehaviourStub)behaviour).getOperation() != gastBehaviourStub.getOperation()) continue;
            this.logger.debug((Object)"Found SEFF behaviour stub, reusing it...");
            seffBehaviourStub = candidateStub;
            break;
        }
        if (seffBehaviourStub == null) {
            seffBehaviourStub = BehaviourFactory.eINSTANCE.createSeffBehaviourStub();
        }
        seffBehaviourStub.setOperation(gastBehaviourStub.getOperation());
        parentComponent.getOperationBehaviour().add((Object)seffBehaviourStub);
        return seffBehaviourStub;
    }
}

