/*
 * Decompiled with CFR 0.152.
 */
package klaper.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SchedulingPolicyKind implements Enumerator
{
    NULL(0, "NULL", "NULL"),
    EARLIEST_DEADLINE_FIRST(1, "EarliestDeadlineFirst", "EarliestDeadlineFirst"),
    FIFO(2, "FIFO", "FIFO"),
    FIXED_PRIORITY(3, "FixedPriority", "FixedPriority"),
    LEAST_LAXITY_FIRST(4, "LeastLaxityFirst", "LeastLaxityFirst"),
    ROUND_ROBIN(5, "RoundRobin", "RoundRobin"),
    TIME_TABLE_DRIVEN(6, "TimeTableDriven", "TimeTableDriven");

    public static final int NULL_VALUE = 0;
    public static final int EARLIEST_DEADLINE_FIRST_VALUE = 1;
    public static final int FIFO_VALUE = 2;
    public static final int FIXED_PRIORITY_VALUE = 3;
    public static final int LEAST_LAXITY_FIRST_VALUE = 4;
    public static final int ROUND_ROBIN_VALUE = 5;
    public static final int TIME_TABLE_DRIVEN_VALUE = 6;
    private static final SchedulingPolicyKind[] VALUES_ARRAY;
    public static final List<SchedulingPolicyKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SchedulingPolicyKind[]{NULL, EARLIEST_DEADLINE_FIRST, FIFO, FIXED_PRIORITY, LEAST_LAXITY_FIRST, ROUND_ROBIN, TIME_TABLE_DRIVEN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SchedulingPolicyKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SchedulingPolicyKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SchedulingPolicyKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SchedulingPolicyKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SchedulingPolicyKind get(int value) {
        switch (value) {
            case 0: {
                return NULL;
            }
            case 1: {
                return EARLIEST_DEADLINE_FIRST;
            }
            case 2: {
                return FIFO;
            }
            case 3: {
                return FIXED_PRIORITY;
            }
            case 4: {
                return LEAST_LAXITY_FIRST;
            }
            case 5: {
                return ROUND_ROBIN;
            }
            case 6: {
                return TIME_TABLE_DRIVEN;
            }
        }
        return null;
    }

    private SchedulingPolicyKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

