/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.text.resource;

import eu.qimpress.identifier.Identifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.linking.impl.SimpleAttributeResolver;
import org.eclipse.xtext.resource.IFragmentProvider;

public class EdificeFragmentProvider
implements IFragmentProvider {
    private static final SimpleAttributeResolver<Identifier, String> IDENTIFIER_RESOLVER = SimpleAttributeResolver.newResolver(String.class, (String)"id");

    public EObject getEObject(Resource resource, String fragment) {
        TreeIterator allContents = resource.getAllContents();
        while (allContents.hasNext()) {
            EObject next = (EObject)allContents.next();
            if (!fragment.equals(this.getFragment(next))) continue;
            return next;
        }
        return this.getEObjectByFragmentPath(resource, fragment);
    }

    public String getFragment(EObject obj) {
        if (obj instanceof Identifier) {
            String id = (String)IDENTIFIER_RESOLVER.apply((EObject)((Identifier)obj));
            return id;
        }
        return this.getFragmentPath(obj);
    }

    private EObject getEObjectByFragmentPath(Resource resource, String uriFragment) {
        int length = uriFragment.length();
        if (length > 0 && uriFragment.charAt(0) == '/') {
            ArrayList<String> uriFragmentPath = new ArrayList<String>(4);
            int start = 1;
            int i = 1;
            while (i < length) {
                if (uriFragment.charAt(i) == '/') {
                    uriFragmentPath.add(start == i ? "" : uriFragment.substring(start, i));
                    start = i + 1;
                }
                ++i;
            }
            uriFragmentPath.add(uriFragment.substring(start));
            int size = uriFragmentPath.size();
            EObject eObject = this.getEObjectForURIFragmentRootSegment(resource, size == 0 ? "" : (String)uriFragmentPath.get(0));
            int i2 = 1;
            while (i2 < size && eObject != null) {
                eObject = ((InternalEObject)eObject).eObjectForURIFragmentSegment((String)uriFragmentPath.get(i2));
                ++i2;
            }
            return eObject;
        }
        return null;
    }

    protected EObject getEObject(Resource resource, List<String> uriFragmentPath) {
        int size = uriFragmentPath.size();
        EObject eObject = this.getEObjectForURIFragmentRootSegment(resource, size == 0 ? "" : uriFragmentPath.get(0));
        int i = 1;
        while (i < size && eObject != null) {
            eObject = ((InternalEObject)eObject).eObjectForURIFragmentSegment(uriFragmentPath.get(i));
            ++i;
        }
        return eObject;
    }

    protected EObject getEObjectForURIFragmentRootSegment(Resource resource, String uriFragmentRootSegment) {
        EList contents;
        int position = 0;
        if (uriFragmentRootSegment.length() > 0) {
            try {
                position = Integer.parseInt(uriFragmentRootSegment);
            }
            catch (NumberFormatException exception) {
                throw new WrappedException((Exception)exception);
            }
        }
        if (position < (contents = resource.getContents()).size() && position >= 0) {
            return (EObject)contents.get(position);
        }
        return null;
    }

    private String getFragmentPath(EObject obj) {
        InternalEObject internalEObject = (InternalEObject)obj;
        ArrayList<String> uriFragmentPath = new ArrayList<String>();
        HashSet<InternalEObject> visited = new HashSet<InternalEObject>();
        InternalEObject container = internalEObject.eInternalContainer();
        while (container != null && visited.add(container)) {
            uriFragmentPath.add(container.eURIFragmentSegment(internalEObject.eContainingFeature(), (EObject)internalEObject));
            internalEObject = container;
            container = internalEObject.eInternalContainer();
        }
        StringBuffer result = new StringBuffer("//");
        int i = uriFragmentPath.size() - 1;
        while (i >= 0) {
            result.append('/');
            result.append((String)uriFragmentPath.get(i));
            --i;
        }
        return result.toString();
    }
}

