/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.model;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.internal.model.QApplicationModelImpl;
import eu.qimpress.ide.backbone.core.internal.model.QModelImpl;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.model.RepositoryModels;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;

public class QImpressApplicationModelManager {
    private static Logger logger = Logger.getLogger(QImpressApplicationModelManager.class);
    private final IQApplicationModel qAppModel = new QApplicationModelImpl();
    private static QImpressApplicationModelManager MANAGER = new QImpressApplicationModelManager();

    public static final QImpressApplicationModelManager getManager() {
        return MANAGER;
    }

    private QImpressApplicationModelManager() {
    }

    public IQApplicationModel getQAppModel() {
        return this.qAppModel;
    }

    public static IQElement create(IResource resource, IQProject qProject) {
        logger.trace((Object)("create method call for resource=" + resource + " and qproject=" + qProject));
        if (resource == null) {
            return null;
        }
        int type = resource.getType();
        switch (type) {
            case 4: {
                return QImpressCore.create((IProject)resource);
            }
            case 8: {
                return QImpressCore.create((IResource)((IWorkspaceRoot)resource), qProject);
            }
            case 2: {
                return QImpressCore.create((IResource)((IFolder)resource), qProject);
            }
            case 1: {
                return QImpressCore.create((IResource)((IFile)resource), qProject);
            }
        }
        return null;
    }

    public static IQElement create(IFolder folder, IQProject project) {
        if (folder == null) {
            return null;
        }
        if (project == null) {
            project = QImpressCore.create(folder.getProject());
        }
        IQRepository repository = null;
        try {
            repository = project.getRepository(folder);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return repository;
    }

    public static IQElement create(IFile file, IQProject project) {
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = QImpressCore.create(file.getProject());
        }
        if (RepositoryModels.isSupportedFileExtension(file.getFileExtension())) {
            return new QModelImpl(file, null);
        }
        return null;
    }

    public static IQModel getModelByResource(IFile file) {
        String alternativeId;
        IQAlternative qAlternative;
        if (file.getParent() != null && file.getParent().exists() && (qAlternative = QImpressCore.getAlternativeById(alternativeId = file.getParent().getName())) != null) {
            IQModel[] models;
            IQModel[] iQModelArray = models = qAlternative.getModels(true);
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IQModel model = iQModelArray[n2];
                if (model.getCorrespondingResource().equals((Object)file)) {
                    return model;
                }
                ++n2;
            }
        }
        return null;
    }
}

