/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.internal.model;

import eu.qimpress.ide.backbone.core.internal.model.ISupportSaveable;
import eu.qimpress.ide.backbone.core.internal.model.QAlternativeInfoImpl;
import eu.qimpress.ide.backbone.core.internal.model.QElement;
import eu.qimpress.ide.backbone.core.internal.model.QModelImpl;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQAlternativeInfo;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.ISaveable;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.model.RepositoryModels;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class QAlternativeImpl
extends QElement
implements IQAlternative,
ISaveable {
    private static final Logger logger = Logger.getLogger(QAlternativeImpl.class);
    public static final String DEFAULT_MODEL_NAME = "model";
    private static final String TEMPORARY_FOLDER_NAME = "tmp";
    private IQAlternative parentAlternative;
    private IFolder alternativeFolder;
    private IQAlternativeInfo alternativeInfo;
    private Map<String, IQModel> models = null;
    private IQRepository repository;

    public QAlternativeImpl(IQRepository repository, IQAlternative parentAlternative) throws RepositoryException {
        this(repository, parentAlternative, new QAlternativeInfoImpl(parentAlternative != null ? parentAlternative.getInfo() : null, null), false);
    }

    public QAlternativeImpl(IQRepository repository, IQAlternative parentAlternative, IQAlternativeInfo alternativeInfo, boolean noCopy) throws RepositoryException {
        super((IQElement)((Object)(parentAlternative != null ? parentAlternative : repository)));
        this.parentAlternative = parentAlternative;
        this.alternativeInfo = alternativeInfo;
        this.alternativeFolder = repository.getRepositoryFolder().getFolder(alternativeInfo.getId());
        this.repository = repository;
        this.postInit();
    }

    protected void postInit() throws RepositoryException {
        if (!this.alternativeFolder.exists()) {
            try {
                this.alternativeFolder.create(true, true, null);
                if (this.parentAlternative != null) {
                    IResource[] parentContent = this.parentAlternative.getAlternativeFolder().members();
                    this.alternativeFolder.getWorkspace().copy(parentContent, this.alternativeFolder.getFullPath(), true, null);
                }
            }
            catch (CoreException e) {
                throw new RepositoryException(e);
            }
        }
    }

    protected void initModels() {
        if (this.models == null) {
            this.models = new HashMap<String, IQModel>();
        }
        this.models.clear();
        try {
            IResource[] members;
            IResource[] iResourceArray = members = this.alternativeFolder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member.exists() && member.getType() == 1 && RepositoryModels.isSupportedFileExtension(member.getFullPath().getFileExtension())) {
                    QModelImpl model = new QModelImpl((IFile)member, this);
                    this.models.put(model.getType(), model);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public IQElement.ElementType getElementType() {
        return IQElement.ElementType.Q_ALTERNATIVE;
    }

    @Override
    public IFolder getAlternativeFolder() {
        return this.alternativeFolder;
    }

    @Override
    public IQAlternativeInfo getInfo() {
        return this.alternativeInfo;
    }

    @Override
    public boolean isTopLevel() {
        return this.parentAlternative == null;
    }

    @Override
    public IQModel getModel(String name) throws RepositoryException {
        IQModel model;
        if (this.models == null) {
            this.initModels();
        }
        if ((model = this.models.get(name)) == null) {
            model = this.createNewModel(DEFAULT_MODEL_NAME, name);
            this.models.put(name, model);
        }
        return model;
    }

    protected IQModel createNewModel(String name, String type) {
        String filename = String.valueOf(name) + "." + type;
        IFile modelFile = this.alternativeFolder.getFile(filename);
        QModelImpl qModel = new QModelImpl(modelFile, this);
        return qModel;
    }

    @Override
    public IQModel[] getModels() {
        return this.getModels(false);
    }

    @Override
    public IQModel[] getModels(boolean refreshModelCache) {
        if (this.models == null || refreshModelCache) {
            this.initModels();
        }
        return this.models.values().toArray(new IQModel[this.models.values().size()]);
    }

    @Override
    public IQModel getStaticStructureModel() throws RepositoryException {
        return this.getModel("samm_repository");
    }

    @Override
    public Iterator<IQModel> iterator() {
        return this.models.values().iterator();
    }

    @Override
    public IResource getCorrespondingResource() {
        return this.alternativeFolder;
    }

    @Override
    public IQRepository getRepository() {
        return this.repository;
    }

    @Override
    public IQModel storeEObject(EObject eo, String filename, String modelType) throws RepositoryException {
        String modelFilename = String.valueOf(filename) + "." + modelType;
        IFile modelFile = this.alternativeFolder.getFile(modelFilename);
        ResourceSetImpl rSet = new ResourceSetImpl();
        IQModel qModel = null;
        try {
            qModel = this.saveModelResource((ResourceSet)rSet, eo, modelFile);
            if (this.models != null) {
                this.models.put(modelType, qModel);
            }
        }
        catch (IOException e) {
            logger.error((Object)"Error occured during saving model into a file", (Throwable)e);
            throw new RepositoryException(e);
        }
        return qModel;
    }

    @Override
    public IQModel[] storeEObject(EObject[] eos, String[] filenames, String[] modelTypes) throws RepositoryException {
        int i;
        assert (eos.length == filenames.length && eos.length == modelTypes.length && filenames.length == modelTypes.length);
        IQModel[] result = new IQModel[eos.length];
        ResourceSetImpl rSet = new ResourceSetImpl();
        try {
            i = 0;
            while (i < eos.length) {
                IQModel qModel;
                EObject eo = eos[i];
                String filename = filenames[i];
                String modelType = modelTypes[i];
                String modelFilename = String.valueOf(filename) + "." + modelType;
                IFile modelFile = this.alternativeFolder.getFile(modelFilename);
                result[i] = qModel = this.saveModelResource((ResourceSet)rSet, eo, modelFile);
                ++i;
            }
        }
        catch (IOException e) {
            logger.error((Object)"Error occured during saving model into a file", (Throwable)e);
            throw new RepositoryException(e);
        }
        if (this.models != null) {
            i = 0;
            while (i < result.length) {
                if (result[i] != null) {
                    this.models.put(result[i].getType(), result[i]);
                }
                ++i;
            }
        }
        return result;
    }

    protected IQModel saveModelResource(ResourceSet rSet, EObject eo, IFile modelFile) throws IOException {
        URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toOSString(), (boolean)false);
        Resource resource = rSet.createResource(fileURI);
        resource.getContents().add((Object)eo);
        resource.save(Collections.EMPTY_MAP);
        QModelImpl qModel = new QModelImpl(modelFile, this);
        return qModel;
    }

    @Override
    public void save() throws RepositoryException {
        if (this.repository instanceof ISupportSaveable && this.alternativeInfo instanceof ISaveable) {
            ((ISupportSaveable)((Object)this.repository)).save((ISaveable)((Object)this.alternativeInfo));
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.alternativeInfo == null ? 0 : this.alternativeInfo.hashCode());
        result = 31 * result + (this.parentAlternative == null ? 0 : this.parentAlternative.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QAlternativeImpl other = (QAlternativeImpl)obj;
        if (this.alternativeInfo == null ? other.alternativeInfo != null : !this.alternativeInfo.equals(other.alternativeInfo)) {
            return false;
        }
        return !(this.parentAlternative == null ? other.parentAlternative != null : !this.parentAlternative.equals(other.parentAlternative));
    }

    public String toString() {
        return "QAlternativeImpl [alternativeInfo=" + this.alternativeInfo + "]";
    }

    @Override
    public void deleteModel(String name) throws RepositoryException {
        QModelImpl m = (QModelImpl)this.models.get(name);
        if (m == null) {
            throw new RepositoryException("No model with the given name.");
        }
        m.internalDelete();
        this.internalDelete(name);
    }

    void internalDelete(String modelName) {
        this.models.remove(modelName);
    }

    @Override
    public IFolder getTemporaryFolder() throws CoreException {
        IFolder altFolder = this.getAlternativeFolder();
        IFolder result = altFolder.getFolder(TEMPORARY_FOLDER_NAME);
        if (!result.exists()) {
            result.create(false, true, null);
        }
        return result;
    }
}

