/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.internal.listeners;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

public class ModelResourceChangedListener
implements IResourceChangeListener {
    private static final Logger logger = Logger.getLogger(ModelResourceChangedListener.class);

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IResourceDelta resourceDelta = event.getDelta();
            this.handleChangedResource(resourceDelta);
        }
    }

    private void handleChangedResource(IResourceDelta resourceDelta) {
        final ArrayList changedModels = new ArrayList();
        final ArrayList addedModels = new ArrayList();
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                IQModel model;
                IResource resource;
                if (delta.getKind() == 4) {
                    IQModel model2;
                    if ((delta.getFlags() & 0x100) == 0) {
                        return true;
                    }
                    IResource resource2 = delta.getResource();
                    if (resource2.getType() == 1 && (model2 = QImpressCore.getModelByFile((IFile)resource2)) != null) {
                        logger.trace((Object)("Model changed: " + model2));
                        changedModels.add(model2);
                    }
                } else if (delta.getKind() == 1 && (resource = delta.getResource()).getType() == 1 && (model = QImpressCore.getModelByFile((IFile)resource)) != null) {
                    logger.trace((Object)("Model added: " + model));
                    addedModels.add(model);
                }
                return true;
            }
        };
        try {
            resourceDelta.accept(visitor);
            if (changedModels.size() > 0) {
                QImpressApplicationModelManager.getManager().getQAppModel().fireModelModified(changedModels.toArray(new IQModel[changedModels.size()]));
            }
            if (addedModels.size() > 0) {
                QImpressApplicationModelManager.getManager().getQAppModel().fireModelCreated(addedModels.toArray(new IQModel[addedModels.size()]));
            }
        }
        catch (CoreException e) {
            logger.error((Object)("Cannot proceed changes in the workspace because of " + e.getMessage()), (Throwable)e);
        }
    }
}

