/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core;

import eu.qimpress.ide.backbone.core.internal.listeners.ModelResourceChangedListener;
import eu.qimpress.ide.backbone.core.internal.listeners.QImpressProjectlResourceChangedListener;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class QImpressCore
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "eu.qimpress.ide.backbone.core";
    public static final String PREF_ACTIVE_ALTERNATIVE = "alternatives.active.alternative";
    public static final String ALTERNATIVES_FOLDER_NAME = "alternatives";
    private static QImpressCore plugin;
    private ModelResourceChangedListener modelResourceChangedListener = new ModelResourceChangedListener();
    private QImpressProjectlResourceChangedListener qImpressProjectlResourceChangedListener = new QImpressProjectlResourceChangedListener();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this.modelResourceChangedListener);
        workspace.addResourceChangeListener((IResourceChangeListener)this.qImpressProjectlResourceChangedListener, 6);
    }

    public void stop(BundleContext context) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.modelResourceChangedListener);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.qImpressProjectlResourceChangedListener);
        plugin = null;
        super.stop(context);
    }

    public static QImpressCore getDefault() {
        return plugin;
    }

    public static IFolder getActiveAlternativeFolder(IProject project) {
        IFolder result = null;
        ProjectScope theProjectScope = new ProjectScope(project);
        IEclipsePreferences pref = theProjectScope.getNode(PLUGIN_ID);
        String folderName = pref.get(PREF_ACTIVE_ALTERNATIVE, "");
        if ("".equals(folderName)) {
            IFolder altFolder = project.getFolder(ALTERNATIVES_FOLDER_NAME);
            if (altFolder != null && altFolder.exists()) {
                try {
                    IResource[] members;
                    IResource[] iResourceArray = members = altFolder.members();
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource member = iResourceArray[n2];
                        if (member instanceof IFolder) {
                            result = (IFolder)member;
                            break;
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {}
                if (result != null) {
                    pref.put(PREF_ACTIVE_ALTERNATIVE, result.getProjectRelativePath().toString());
                    try {
                        pref.flush();
                    }
                    catch (BackingStoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            result = project.getFolder(folderName);
        }
        return result;
    }

    public static IQElement create(IResource resource) {
        return QImpressApplicationModelManager.create(resource, null);
    }

    public static IQElement create(IResource resource, IQProject project) {
        return QImpressApplicationModelManager.create(resource, project);
    }

    public static IQApplicationModel create(IWorkspaceRoot root) {
        if (root == null) {
            return null;
        }
        return QImpressApplicationModelManager.getManager().getQAppModel();
    }

    public static IQProject create(IProject project) {
        if (project == null) {
            return null;
        }
        IQApplicationModel qAppModel = QImpressApplicationModelManager.getManager().getQAppModel();
        return qAppModel.getQProject(project);
    }

    public static IQElement create(IFolder folder) {
        return QImpressApplicationModelManager.create(folder, null);
    }

    public static IQElement create(IFile file) {
        return QImpressApplicationModelManager.create(file, null);
    }

    public static IQAlternative getAlternativeById(String id) {
        IQElement element = QImpressApplicationModelManager.getManager().getQAppModel().getElementByID(id);
        if (element != null && element.getElementType() == IQElement.ElementType.Q_ALTERNATIVE) {
            return (IQAlternative)element;
        }
        return null;
    }

    public static IQModel getModelByFile(IFile file) {
        return QImpressApplicationModelManager.getModelByResource(file);
    }

    public static IProject getProject(URI platformURI) {
        IProject result = null;
        if (platformURI.isPlatform()) {
            String projectName = URI.decode((String)platformURI.segment(1));
            IWorkspaceRoot wRoot = ResourcesPlugin.getWorkspace().getRoot();
            result = wRoot.getProject(projectName);
        } else if (platformURI.isFile()) {
            Path filePath = new Path(platformURI.toFileString());
            IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            filePath = filePath.makeRelativeTo(workspacePath);
            String projectName = filePath.segment(0);
            result = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return result;
    }

    public static boolean isGlobalAlternative(IQAlternative alternative) {
        String alternativeID = alternative.getInfo().getId();
        return "0".equals(alternativeID);
    }

    public static IQProject getQProject(IProject project) {
        return QImpressApplicationModelManager.getManager().getQAppModel().getQProject(project);
    }
}

