/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.wizards;

import eu.qimpress.ide.backbone.core.operations.InitializeQImpressProjectOperation;
import eu.qimpress.ide.backbone.core.utils.ProjectUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class QImPrESSNewProjectWizard
extends BasicNewProjectResourceWizard {
    private static final Logger logger = Logger.getLogger(QImPrESSNewProjectWizard.class);
    public static final String WIZARD_ID = "eu.qimpress.ide.backbone.core.ui.QImPrESSNewProjectWizardID";

    public boolean performFinish() {
        if (super.performFinish()) {
            IProject project = this.getNewProject();
            try {
                logger.trace((Object)"Trying to toggle Q-ImPrESS nature");
                InitializeQImpressProjectOperation operation = new InitializeQImpressProjectOperation(project);
                this.getContainer().run(false, false, (IRunnableWithProgress)operation);
                ProjectUtils.toggleNature((IProject)project);
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                workbench.showPerspective("eu.qimpress.ide.perspective.QIPerspectiveID", window);
            }
            catch (Exception e) {
                logger.error((Object)("Cannot toggle Q-Impress nature for project " + project), (Throwable)e);
                MessageDialog.openError((Shell)this.getShell(), (String)"Q-ImPrESS project creation failed", (String)"Q-ImPrESS nature toggling failed - see log for details");
            }
            return true;
        }
        return false;
    }
}

