/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.tabs;

import ResultModel.AlternativeEvaluation;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativeEvaluationSelectorWidgetFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class QImpressAlternativeEvaluationSelectionTab
extends AbstractLaunchConfigurationTab {
    public static final String SELECTED_ALTERNATIVE_EVALUATION_ID = "eu.qimpress.ide.backbone.core.ui.AlternativeEvaluationSelection";
    private CheckboxTreeViewer alternativeEvaluationViewer;
    private Label selectionText;

    public void createControl(Composite parent) {
        Composite myTabControl = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 2;
        myTabControl.setLayout((Layout)gridLayout);
        this.setControl((Control)myTabControl);
        Group grpSelectQimpressAlternative = new Group(myTabControl, 4);
        grpSelectQimpressAlternative.setText("Select Alternative Evaluation");
        FillLayout fillLayout = new FillLayout(256);
        fillLayout.marginWidth = 5;
        fillLayout.marginHeight = 5;
        grpSelectQimpressAlternative.setLayout((Layout)fillLayout);
        grpSelectQimpressAlternative.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.alternativeEvaluationViewer = (CheckboxTreeViewer)QAlternativeEvaluationSelectorWidgetFactory.createWidgetFactory((Composite)grpSelectQimpressAlternative).getWidget();
        this.alternativeEvaluationViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof AlternativeEvaluation && event.getChecked()) {
                    AlternativeEvaluation alternativeEvaluation = (AlternativeEvaluation)event.getElement();
                    QImpressAlternativeEvaluationSelectionTab.this.selectionText.setText(String.valueOf(alternativeEvaluation.getName()) + " (" + alternativeEvaluation.getAlternativeId() + ")");
                } else if (event.getElement() instanceof AlternativeEvaluation) {
                    QImpressAlternativeEvaluationSelectionTab.this.selectionText.setText("<none>");
                }
                QImpressAlternativeEvaluationSelectionTab.this.setDirty(true);
                QImpressAlternativeEvaluationSelectionTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label selection = new Label(myTabControl, 0);
        selection.setText("Selected Alternative Evaluation: ");
        selection.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.selectionText = new Label(myTabControl, 0);
        this.selectionText.setText("<none>");
        this.selectionText.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
    }

    public String getName() {
        return "QImPrESS Alternative Evaluation";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        IQApplicationModel model;
        IQElement alternative;
        String guid = "";
        try {
            guid = configuration.getAttribute(SELECTED_ALTERNATIVE_EVALUATION_ID, "");
        }
        catch (CoreException coreException) {}
        if (!guid.equals("") && (alternative = (model = (IQApplicationModel)this.alternativeEvaluationViewer.getInput()).getElementByID(guid)) != null) {
            this.alternativeEvaluationViewer.setChecked((Object)alternative, true);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Object[] elements = this.alternativeEvaluationViewer.getCheckedElements();
        if (elements.length != 1 || !(elements[0] instanceof AlternativeEvaluation)) {
            configuration.setAttribute(SELECTED_ALTERNATIVE_EVALUATION_ID, "");
        } else {
            AlternativeEvaluation selectedAlternativeEvaluation = (AlternativeEvaluation)elements[0];
            configuration.setAttribute(SELECTED_ALTERNATIVE_EVALUATION_ID, selectedAlternativeEvaluation.getId());
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (!super.isValid(launchConfig)) {
            return false;
        }
        return this.getErrorMessage() == null;
    }

    public String getErrorMessage() {
        Object[] elements = this.alternativeEvaluationViewer.getCheckedElements();
        if (elements.length != 1) {
            return "Select a single alternative evaluation";
        }
        if (!(elements[0] instanceof AlternativeEvaluation)) {
            return "Selection is not an alternative evaluation";
        }
        return null;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(SELECTED_ALTERNATIVE_EVALUATION_ID, "");
    }
}

