/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.decorators;

import eu.qimpress.ide.backbone.core.model.IQModel;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;

public class QModelNeedsSaveDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private static final Logger logger = Logger.getLogger(QModelNeedsSaveDecorator.class);
    public static final String DECORATOR_ID = "eu.qimpress.ide.backbone.core.ui.UnsavedModelDecorator";

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IQModel) {
            try {
                if (((IQModel)element).getCorrespondingResource().exists()) {
                    IMarker[] markers = ((IQModel)element).getCorrespondingResource().findMarkers("eu.qimpress.ide.backbone.core.ui.QModelNeedsSave", true, 0);
                    if (markers.length > 0) {
                        decoration.addSuffix(" [ MODIFIED ]");
                    }
                } else {
                    logger.warn((Object)("Cannot get marker because of resource does not exist. IQModel: " + element));
                }
            }
            catch (CoreException e) {
                logger.debug((Object)("Cannot get markars for element: " + element), (Throwable)e);
            }
        }
    }

    public static QModelNeedsSaveDecorator getDecorator() {
        IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        if (decoratorManager.getEnabled(DECORATOR_ID)) {
            return (QModelNeedsSaveDecorator)decoratorManager.getBaseLabelProvider(DECORATOR_ID);
        }
        return null;
    }

    public void refresh(IQModel[] models) {
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object[])models));
    }
}

