/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.operations.SaveQModelUIOperation;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class SaveModelAction
implements IObjectActionDelegate {
    private static final Logger logger = Logger.getLogger(SaveModelAction.class);
    private Shell shell;
    private IQModel selectedQModel;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        if (this.selectedQModel == null) {
            return;
        }
        try {
            new SaveQModelUIOperation(this.selectedQModel).run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            logger.error((Object)("Cannot save selected model: " + this.selectedQModel), (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Model save failed", (String)("Cannot save model " + this.selectedQModel));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedQModel = null;
        action.setEnabled(false);
        if (selection instanceof IStructuredSelection && !((IStructuredSelection)selection).isEmpty()) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof IQModel) {
                this.selectedQModel = (IQModel)element;
            } else if (element instanceof IAdaptable) {
                this.selectedQModel = (IQModel)((IAdaptable)element).getAdapter(IQModel.class);
            }
        }
        if (this.selectedQModel != null) {
            IResource modelResource = this.selectedQModel.getCorrespondingResource();
            try {
                if (modelResource.findMarkers("eu.qimpress.ide.backbone.core.ui.QModelNeedsSave", true, 0).length > 0) {
                    action.setEnabled(true);
                }
            }
            catch (CoreException coreException) {}
        }
    }

    protected Shell getShell() {
        return this.shell;
    }
}

