/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.ui.actions.QElementSelectionDispatchAction;
import eu.qimpress.ide.backbone.core.ui.internal.QImpressUICorePluginImages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ISetSelectionTarget;

public class DeleteModelAction
extends QElementSelectionDispatchAction {
    public DeleteModelAction(IWorkbenchSite site) {
        this(site, null);
    }

    public DeleteModelAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget) {
        super(site, selectionTarget);
        this.setText("Delete Model");
        this.setDescription("Delete selected model");
        this.setToolTipText("Deletes selected model.");
        this.setImageDescriptor(QImpressUICorePluginImages.DESC_RED_DELETE);
    }

    @Override
    protected void runInternal(IQModel model) {
        if (this.canDelete(model)) {
            try {
                this.unselect();
                model.delete();
                QImpressApplicationModelManager.getManager().getQAppModel().fireRefresh();
            }
            catch (RepositoryException repositoryException) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Delete model", (String)"Cannot delete model");
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Delete model", (String)"Successfully deleted.");
        }
    }

    private boolean canDelete(IQModel model) {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)"Delete model", (String)("Do you want really delete the model " + model.getName() + "?"));
    }

    @Override
    protected void postSelectionChanged(IQElement element) {
        if (element != null && element instanceof IQModel) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

