/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.ui.actions.QElementSelectionDispatchAction;
import eu.qimpress.ide.backbone.core.ui.internal.QImpressUICorePluginImages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public class CompleteDeleteAlternativeAction
extends QElementSelectionDispatchAction {
    public CompleteDeleteAlternativeAction(IWorkbenchSite site) {
        super(site);
        this.setText("Completly delete alternative");
        this.setDescription("Delete selected alternative with child alternatives recursively");
        this.setToolTipText("Deletes selected alternative with child alternatives recursively. Deletes also models in the alternatives.");
        this.setImageDescriptor(QImpressUICorePluginImages.DESC_RED_DELETE);
    }

    @Override
    protected void runInternal(IQAlternative alternative) {
        alternative.getRepository();
        if (this.canDelete(alternative)) {
            try {
                alternative.getRepository().deleteAlternative(alternative, true, true);
                QImpressApplicationModelManager.getManager().getQAppModel().fireRefresh();
            }
            catch (RepositoryException repositoryException) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Delete alternative", (String)"Cannot delete alternative");
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Delete alternative", (String)"Successfully deleted.");
        }
    }

    private boolean canDelete(IQAlternative alternative) {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)"Delete alternative", (String)("Do you want really delete the alternative " + alternative.getInfo().getDescription() + " with all its child alternatives?"));
    }

    @Override
    protected void postSelectionChanged(IQElement element) {
        if (element != null && element instanceof IQAlternative && !((IQAlternative)element).getInfo().isDefault()) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

