/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.models.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;

public class QModelsComposedAdapterFactoryProvider {
    private static final Logger logger = Logger.getLogger(QModelsComposedAdapterFactoryProvider.class);
    private static final boolean ONLY_Q_IMPRESS_FACTORIES = false;
    private static final QModelsComposedAdapterFactoryProvider INSTANCE = new QModelsComposedAdapterFactoryProvider(false);
    private ComposedAdapterFactory adapterFactory;
    private boolean onlyQImpressFactories;

    private QModelsComposedAdapterFactoryProvider(boolean filterQImpressPackages) {
        this.setOnlyQImpressFactories(filterQImpressPackages);
    }

    public static final QModelsComposedAdapterFactoryProvider getInstance() {
        return INSTANCE;
    }

    protected List<AdapterFactory> createFactoryList() {
        HashMap<String, AdapterFactory> list = new HashMap<String, AdapterFactory>();
        logger.trace((Object)"Initialization of adapter factories");
        if (ComposedAdapterFactory.Descriptor.Registry.INSTANCE instanceof HashMap) {
            Set descriptors = ((HashMap)ComposedAdapterFactory.Descriptor.Registry.INSTANCE).entrySet();
            for (Map.Entry entry : descriptors) {
                String modelURL;
                if (this.isOnlyQImpressFactories() && (!this.isOnlyQImpressFactories() || !this.isQImpressAdapter((Collection)entry.getKey())) || list.containsKey(modelURL = this.getModelURL((Collection)entry.getKey())) || !(entry.getValue() instanceof ComposedAdapterFactory.Descriptor)) continue;
                try {
                    ComposedAdapterFactory.Descriptor desc = (ComposedAdapterFactory.Descriptor)entry.getValue();
                    list.put(modelURL, desc.createAdapterFactory());
                }
                catch (Exception e) {
                    logger.trace((Object)"Cannot create adapter factory. Skipped.", (Throwable)e);
                }
            }
        }
        return new ArrayList<AdapterFactory>(list.values());
    }

    protected String getModelURL(Collection<?> key) {
        for (Object o : key) {
            if (!(o instanceof String) || !((String)o).startsWith("http")) continue;
            return (String)o;
        }
        return null;
    }

    protected boolean isQImpressAdapter(Collection<?> key) {
        for (Object o : key) {
            String s;
            if (!(o instanceof String) || !(s = (String)o).contains("q-impress") && !s.contains("qimpress") && !s.contains("fzi") && !s.contains("uka.de") && !s.contains("ecore")) continue;
            return true;
        }
        return false;
    }

    public synchronized void initializeFactoryProvider() {
        if (this.adapterFactory == null) {
            logger.info((Object)"Initializing adapter factory for the accessible Q-ImPrESS models ...");
            this.adapterFactory = new ComposedAdapterFactory(this.createFactoryList());
            logger.info((Object)"Initialization finished");
        }
    }

    public final ComposedAdapterFactory getAdapterFactory() {
        this.initializeFactoryProvider();
        return this.adapterFactory;
    }

    public void setOnlyQImpressFactories(boolean onlyQImpressFactories) {
        this.onlyQImpressFactories = onlyQImpressFactories;
    }

    public boolean isOnlyQImpressFactories() {
        return this.onlyQImpressFactories;
    }
}

