/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.models.adapters;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModelChangeListener;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.ui.models.ShadowModelEditor;
import eu.qimpress.ide.backbone.core.ui.models.adapters.QModelsComposedAdapterFactoryProvider;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class QModelEditorAdapterFactory
implements IAdapterFactory {
    private static Map<IQAlternative, ShadowModelEditor> modelEditorsMap = new HashMap<IQAlternative, ShadowModelEditor>();
    private IPropertySourceProvider propertySourceProvider = new AdapterFactoryContentProvider((AdapterFactory)QModelsComposedAdapterFactoryProvider.getInstance().getAdapterFactory());
    private static final Class[] SUPPORTED_ADAPTERS = new Class[]{IEditingDomainProvider.class, ShadowModelEditor.class, IPropertySource.class, Resource.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (IEditingDomainProvider.class.equals((Object)adapterType)) {
            return this.handleIEditingDomainProviderAdapter(adaptableObject);
        }
        if (ShadowModelEditor.class.equals((Object)adapterType)) {
            return this.handleShadowModelEditorAdapter(adaptableObject);
        }
        if (IPropertySource.class.equals((Object)adapterType)) {
            return this.handleIPropertySourceAdapter(adaptableObject);
        }
        if (Resource.class.equals((Object)adapterType)) {
            return this.handleEMFResourceAdapter(adaptableObject);
        }
        return null;
    }

    private Resource handleEMFResourceAdapter(Object adaptableObject) {
        Resource resource = null;
        if (adaptableObject instanceof IQModel) {
            IQModel qModel = (IQModel)adaptableObject;
            IQAlternative alternative = (IQAlternative)((IQModel)adaptableObject).getParent();
            ShadowModelEditor shadowModelEditor = this.getEditor(alternative);
            resource = !qModel.getCorrespondingResource().exists() ? shadowModelEditor.createModelResource(qModel) : shadowModelEditor.getModelResource(qModel);
        }
        return resource;
    }

    private Object handleIPropertySourceAdapter(Object adaptableObject) {
        if (adaptableObject instanceof EObject) {
            return this.propertySourceProvider.getPropertySource(adaptableObject);
        }
        return null;
    }

    protected Object handleShadowModelEditorAdapter(Object adaptableObject) {
        if (adaptableObject instanceof ShadowModelEditor) {
            return adaptableObject;
        }
        if (adaptableObject instanceof IQAlternative) {
            return this.getEditor((IQAlternative)adaptableObject);
        }
        return null;
    }

    protected Object handleIEditingDomainProviderAdapter(Object adaptableObject) {
        if (adaptableObject instanceof IEditingDomainProvider) {
            return adaptableObject;
        }
        if (adaptableObject instanceof IQAlternative) {
            return this.getEditor((IQAlternative)adaptableObject);
        }
        return null;
    }

    protected ShadowModelEditor getEditor(IQAlternative alternative) {
        ShadowModelEditor editor = null;
        if (modelEditorsMap.containsKey(alternative)) {
            editor = modelEditorsMap.get(alternative);
        } else {
            editor = new ShadowModelEditor(alternative);
            modelEditorsMap.put(alternative, editor);
            QImpressApplicationModelManager.getManager().getQAppModel().addChangeListener((IQApplicationModelChangeListener)editor);
        }
        return editor;
    }

    public Class[] getAdapterList() {
        return SUPPORTED_ADAPTERS;
    }
}

