/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.jobs;

import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.IJobWithResult;
import de.uka.ipd.sdq.workflow.OrderPreservingBlackboardCompositeJob;
import de.uka.ipd.sdq.workflow.exceptions.InvalidWorkflowJobConfiguration;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ModelLocation;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.SavePartitionToDiskJob;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.QVTOTransformationJob;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.QVTOTransformationJobConfiguration;
import eu.qimpress.dtmc.DtmcPackage;
import eu.qimpress.ide.analysis.realiability.Activator;
import eu.qimpress.ide.analysis.realiability.jobs.prism.PrismAnalysisJob;
import eu.qimpress.ide.analysis.realiability.jobs.prism.PrismAnalysisJobConf;
import eu.qimpress.ide.analysis.realiability.launch.ReliabilityConfiguration;
import eu.qimpress.ide.analysis.reliability.jobs.PrepareReliabilityBlackboardPartitionConf;
import eu.qimpress.ide.analysis.reliability.jobs.PrepareReliabiltyBlackboardPartionJob;
import eu.qimpress.ide.analysis.reliability.jobs.SysCallAnalysisJobConf;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.transformations.common.jobs.LoadSAMMAlternativeJob;
import eu.qimpress.transformations.common.oaw.LazyXpandGeneratorJob;
import java.io.File;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.xpand2.output.Outlet;

public class SysCallAnalysisJob
extends OrderPreservingBlackboardCompositeJob<MDSDBlackboard>
implements IJobWithResult<Float> {
    private Logger logger = Logger.getLogger(SysCallAnalysisJob.class);
    private static final int SAMM2KLAPER_PARAM_NUMBER = 6;
    private static final int KLAPER2DTMC_PARAM_NUMBER = 2;
    private static final int DTMCPREP_PARAM_NUMBER = 2;
    private String reliabilityPartitionName;
    private PrismAnalysisJob prismAnalysisJob;
    private SysCallAnalysisJobConf config;

    public SysCallAnalysisJob(SysCallAnalysisJobConf config) throws InvalidWorkflowJobConfiguration {
        this.config = config;
        PrepareReliabilityBlackboardPartitionConf prbpConf = new PrepareReliabilityBlackboardPartitionConf();
        prbpConf.setPartitionName(config.getSyscallId());
        this.reliabilityPartitionName = prbpConf.getPartitionName();
        this.add(new PrepareReliabiltyBlackboardPartionJob(prbpConf));
        QVTOTransformationJob samm2klaperJob = new QVTOTransformationJob(this.createSamm2KlaperConf(config));
        this.add((IJob)samm2klaperJob);
        this.add((IJob)new SavePartitionToDiskJob(this.reliabilityPartitionName));
        QVTOTransformationJob klaper2dtmcJob = new QVTOTransformationJob(this.createKlaper2DtmcConf(config));
        this.add((IJob)klaper2dtmcJob);
        QVTOTransformationJob dtmcPreparationJob = new QVTOTransformationJob(this.createDtmcPreparationConf(config));
        this.add((IJob)dtmcPreparationJob);
        this.add((IJob)new SavePartitionToDiskJob(this.reliabilityPartitionName));
        LazyXpandGeneratorJob dtmc2prismModelJob = this.createDtmc2PrismJob(config, "eu::qimpress::transformations::reliability::m2t::dtmc2prism::files::generateModel");
        this.add((IJob)dtmc2prismModelJob);
        LazyXpandGeneratorJob dtmc2prismPropsJob = this.createDtmc2PrismJob(config, "eu::qimpress::transformations::reliability::m2t::dtmc2prism::files::generateProperties");
        this.add((IJob)dtmc2prismPropsJob);
        this.prismAnalysisJob = new PrismAnalysisJob(this.createLaunchPrismAnalysisJobConf(config));
        this.add((IJob)this.prismAnalysisJob);
    }

    private QVTOTransformationJobConfiguration createSamm2KlaperConf(SysCallAnalysisJobConf config) {
        QVTOTransformationJobConfiguration jobConf = new QVTOTransformationJobConfiguration();
        HashMap<String, String> mtOpt = new HashMap<String, String>();
        this.logger.debug((Object)"Samm2Klaper : setting transformation options...");
        mtOpt.put("scenario", config.getUsageScenarioName());
        mtOpt.put("systemcall", config.getSyscallName());
        ModelLocation[] inoutModels = new ModelLocation[6];
        ReliabilityConfiguration reliabilityConf = config.getReliabilityConf();
        this.logger.debug((Object)"Samm2Klaper : setting input models...");
        inoutModels[1] = new ModelLocation("eu.qimpress.samm.partition", reliabilityConf.getModelURI(reliabilityConf.getRepositoryModel()));
        inoutModels[0] = new ModelLocation("eu.qimpress.samm.partition", reliabilityConf.getModelURI(reliabilityConf.getSammModel()));
        inoutModels[2] = new ModelLocation("eu.qimpress.samm.partition", reliabilityConf.getModelURI(reliabilityConf.getSeffBehavioralModel()));
        inoutModels[3] = new ModelLocation("eu.qimpress.samm.partition", reliabilityConf.getModelURI(reliabilityConf.getAnnotationsModel()));
        inoutModels[4] = new ModelLocation("eu.qimpress.samm.partition", reliabilityConf.getModelURI(reliabilityConf.getUsageProfilesModel()));
        this.logger.debug((Object)"Samm2Klaper : setting output models...");
        inoutModels[5] = new ModelLocation(this.reliabilityPartitionName, this.getKlaperModelURI(config));
        this.logger.debug((Object)"Samm2Klaper : saving configuration...");
        jobConf.setInoutModels(inoutModels);
        jobConf.setOptions(mtOpt);
        this.logger.debug((Object)"Samm2Klaper : setting traces and script location...");
        URI traceFileURI = LoadSAMMAlternativeJob.getURIForQIElement((IQElement)reliabilityConf.getAlternative()).appendSegment("Samm2Klaper.qvtotrace");
        jobConf.setTraceFileURI(traceFileURI);
        URI tScriptURI = URI.createPlatformPluginURI((String)"eu.qimpress.transformations.reliability.m2m.samm2klaper/transforms/samm2klaper.qvto", (boolean)true);
        jobConf.setScriptFileURI(tScriptURI);
        return jobConf;
    }

    private QVTOTransformationJobConfiguration createKlaper2DtmcConf(SysCallAnalysisJobConf config) {
        QVTOTransformationJobConfiguration jobConf = new QVTOTransformationJobConfiguration();
        HashMap mtOpt = new HashMap();
        this.logger.debug((Object)"Klaper2Dtmc : setting transformation options...");
        ModelLocation[] inoutModels = new ModelLocation[2];
        this.logger.debug((Object)"Klaper2Dtmc : setting input models...");
        inoutModels[0] = new ModelLocation(this.reliabilityPartitionName, this.getKlaperModelURI(config));
        this.logger.debug((Object)"Klaper2Dtmc : setting output models...");
        inoutModels[1] = new ModelLocation(this.reliabilityPartitionName, this.getDtmcModelURI(config));
        this.logger.debug((Object)"Klaper2Dtmc : saving configuration...");
        jobConf.setInoutModels(inoutModels);
        jobConf.setOptions(mtOpt);
        this.logger.debug((Object)"Klaper2Dtmc : setting traces and script location...");
        URI traceFileURI = LoadSAMMAlternativeJob.getURIForQIElement((IQElement)config.getReliabilityConf().getAlternative()).appendSegment("Klaper2Dtmc.qvtotrace");
        jobConf.setTraceFileURI(traceFileURI);
        URI tScriptURI = URI.createPlatformPluginURI((String)"eu.qimpress.transformations.reliability.m2m.klaper2dtmc/transforms/klaper2dtmc.qvto", (boolean)true);
        jobConf.setScriptFileURI(tScriptURI);
        return jobConf;
    }

    private QVTOTransformationJobConfiguration createDtmcPreparationConf(SysCallAnalysisJobConf config) {
        QVTOTransformationJobConfiguration jobConf = new QVTOTransformationJobConfiguration();
        HashMap mtOpt = new HashMap();
        this.logger.debug((Object)"DtmcPreparation : setting transformation options...");
        ModelLocation[] inoutModels = new ModelLocation[2];
        this.logger.debug((Object)"DtmcPreparation : setting input models...");
        inoutModels[0] = new ModelLocation(this.reliabilityPartitionName, this.getDtmcModelURI(config));
        this.logger.debug((Object)"DtmcPreparation : setting output models...");
        inoutModels[1] = new ModelLocation(this.reliabilityPartitionName, this.getDtmcModelURI(config));
        this.logger.debug((Object)"DtmcPreparation : saving configuration...");
        jobConf.setInoutModels(inoutModels);
        jobConf.setOptions(mtOpt);
        this.logger.debug((Object)"DtmcPreparation : setting traces and script location...");
        URI traceFileURI = LoadSAMMAlternativeJob.getURIForQIElement((IQElement)config.getReliabilityConf().getAlternative()).appendSegment("Klaper2Dtmc.qvtotrace");
        jobConf.setTraceFileURI(traceFileURI);
        URI tScriptURI = URI.createPlatformPluginURI((String)"eu.qimpress.transformations.reliability.m2m.dtmcPreparation/transforms/dtmcPreparation.qvto", (boolean)true);
        jobConf.setScriptFileURI(tScriptURI);
        return jobConf;
    }

    private LazyXpandGeneratorJob createDtmc2PrismJob(SysCallAnalysisJobConf config, String template) {
        Outlet[] outlets = new Outlet[]{new Outlet()};
        outlets[0].setPath(this.getLocalOutputFolder(config).getLocation().toString());
        EPackage[] ePackages = new EPackage[]{DtmcPackage.eINSTANCE};
        HashMap<String, ModelLocation> slots = new HashMap<String, ModelLocation>();
        slots.put("model", new ModelLocation(this.reliabilityPartitionName, this.getDtmcModelURI(config)));
        String value = System.getProperty("org.apache.commons.logging.Log");
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        LazyXpandGeneratorJob job = new LazyXpandGeneratorJob(slots, ePackages, outlets, String.valueOf(template) + "::main FOR model", "UTF-8");
        System.setProperty("org.apache.commons.logging.Log", value);
        return job;
    }

    private PrismAnalysisJobConf createLaunchPrismAnalysisJobConf(SysCallAnalysisJobConf config) {
        PrismAnalysisJobConf conf = new PrismAnalysisJobConf();
        this.logger.debug((Object)"Prism Analysis : setting prism executable path...");
        IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        conf.setPrismExecutable(new File(prefStore.getString("prismExecutable")));
        this.logger.debug((Object)"Prism Analysis : setting input model...");
        conf.setModelFile(new File(this.getLocalOutputFolder(config).getFile("output.pm").getLocation().toString()));
        this.logger.debug((Object)"Prism Analysis : setting input properties...");
        conf.setPropsFile(new File(this.getLocalOutputFolder(config).getFile("properties.pctl").getLocation().toString()));
        this.logger.debug((Object)"Prism Analysis : setting output file...");
        conf.setOutputFile(new File(this.getLocalOutputFolder(config).getFile("output.prism").getLocation().toString()));
        this.logger.debug((Object)"Prism Analysis : setting temporary directory...");
        conf.setTempDir(new File(this.getLocalOutputFolder(config).getLocation().toString()));
        return conf;
    }

    private IFolder getLocalOutputFolder(SysCallAnalysisJobConf config) {
        return config.getReliabilityConf().getOutputFolder().getFolder(config.getSyscallId());
    }

    private URI getKlaperModelURI(SysCallAnalysisJobConf config) {
        return URI.createFileURI((String)this.getLocalOutputFolder(config).getFile("/out.klaper").getLocation().toString());
    }

    private URI getDtmcModelURI(SysCallAnalysisJobConf config) {
        return URI.createFileURI((String)this.getLocalOutputFolder(config).getFile("/out.dtmc").getLocation().toString());
    }

    public Float getResult() {
        return Float.valueOf(Float.parseFloat((String)this.prismAnalysisJob.getResult().values().iterator().next()));
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    public SysCallAnalysisJobConf getConfiguration() {
        return this.config;
    }
}

