/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.jobs;

import ResultModel.AlternativeEvaluation;
import ResultModel.Reliability;
import ResultModel.ReliabilityPredictionResult;
import ResultModel.ResultDistribution;
import ResultModel.ResultModelFactory;
import ResultModel.ResultModelPackage;
import ResultModel.ResultRepository;
import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import eu.qimpress.ide.analysis.reliability.jobs.FillResultsModelJobConf;
import eu.qimpress.ide.analysis.reliability.jobs.SysCallAnalysisJob;
import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;
import eu.qimpress.samm.usagemodel.SystemCall;
import eu.qimpress.samm.usagemodel.Usage;
import eu.qimpress.samm.usagemodel.UsageScenario;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class FillResultsModelJob
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private Logger logger = Logger.getLogger(FillResultsModelJob.class);
    private static final String JOB_NAME = "Fill Results Model Job";
    private MDSDBlackboard blackboard;
    private FillResultsModelJobConf conf;
    private String alternativeEvaluationId;

    public FillResultsModelJob(FillResultsModelJobConf conf) {
        this.conf = conf;
    }

    private void check() throws JobFailedException {
        if (!this.conf.isValid()) {
            throw new JobFailedException(this.conf.getErrorMessage());
        }
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        this.check();
        ResultModelFactory factory = ResultModelPackage.eINSTANCE.getResultModelFactory();
        this.logger.debug((Object)"Loading samm...");
        List contents = this.blackboard.getContents(this.conf.getSammModelLocation());
        ServiceArchitectureModel samm = (ServiceArchitectureModel)contents.iterator().next();
        this.logger.debug((Object)"Loading results repository...");
        contents = this.blackboard.getContents(this.conf.getResultsModelLocation());
        ResultRepository rr = (ResultRepository)contents.iterator().next();
        this.logger.debug((Object)"Retrieving usage scenario...");
        contents = this.blackboard.getContents(this.conf.getUsageModelLocation());
        Usage um = (Usage)contents.iterator().next();
        UsageScenario us = null;
        for (UsageScenario tmpUs : um.getUsageScenarios()) {
            if (!tmpUs.getId().equals(this.conf.getReliabilityConf().getUsageScenarioId())) continue;
            us = tmpUs;
        }
        this.logger.debug((Object)"Creating alternative evaluation...");
        AlternativeEvaluation ae = factory.createAlternativeEvaluation();
        ae.setName("Realiability Analysis");
        ae.setDocumentation("Reliability Analysis");
        ae.setAlternativeId(this.conf.getReliabilityConf().getAlternativeId());
        ae.setRunDate(new Date());
        ae.setServiceArchitectureModel(samm);
        ae.setUsageModel(us);
        this.alternativeEvaluationId = ae.getId();
        this.logger.debug((Object)"Adding alternative evaluation to repository...");
        rr.getAnalysisRuns().add((Object)ae);
        this.logger.debug((Object)"Adding prediction results...");
        ReliabilityPredictionResult rpr = factory.createReliabilityPredictionResult();
        ae.getAnalysisResults().add((Object)rpr);
        rpr.getReliabilities();
        for (SysCallAnalysisJob sysCallAnalysis : this.conf.getSysCallAnalysisJobs()) {
            String sysCallId = sysCallAnalysis.getConfiguration().getSyscallId();
            Float value = sysCallAnalysis.getResult();
            ResultDistribution distribution = factory.createResultDistribution();
            distribution.setArithmeticMean((double)value.floatValue());
            Reliability reliability = factory.createReliability();
            reliability.setResultDistribution(distribution);
            SystemCall sc = null;
            for (SystemCall tmpSc : us.getSystemCalls()) {
                if (!tmpSc.getId().equals(sysCallId)) continue;
                sc = tmpSc;
                break;
            }
            reliability.setUsageScenario(sc);
            this.logger.debug((Object)("Adding reliability result for syscall" + sysCallId + "..."));
            rpr.getReliabilities().add((Object)reliability);
        }
    }

    public String getName() {
        return JOB_NAME;
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
        this.logger.debug((Object)"Loading results repository...");
        List contents = this.blackboard.getContents(this.conf.getResultsModelLocation());
        ResultRepository rr = (ResultRepository)contents.iterator().next();
        AlternativeEvaluation ae = null;
        for (AlternativeEvaluation tmpAe : rr.getAnalysisRuns()) {
            if (!tmpAe.getId().equals(this.alternativeEvaluationId)) continue;
            ae = tmpAe;
            break;
        }
        if (ae != null) {
            rr.getAnalysisRuns().remove(ae);
        }
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

