/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.realiability.launch;

import de.uka.ipd.sdq.workflow.Blackboard;
import de.uka.ipd.sdq.workflow.BlackboardBasedWorkflow;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.OrderPreservingBlackboardCompositeJob;
import de.uka.ipd.sdq.workflow.exceptions.InvalidWorkflowJobConfiguration;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedLaunchConfigurationDelegate;
import de.uka.ipd.sdq.workflow.launchconfig.LoggerAppenderStruct;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ModelLocation;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.SavePartitionToDiskJob;
import de.uka.ipd.sdq.workflow.ui.UIBasedWorkflow;
import eu.qimpress.ide.analysis.realiability.launch.ReliabilityConfiguration;
import eu.qimpress.ide.analysis.reliability.jobs.FillResultsModelJob;
import eu.qimpress.ide.analysis.reliability.jobs.FillResultsModelJobConf;
import eu.qimpress.ide.analysis.reliability.jobs.SysCallAnalysisJob;
import eu.qimpress.ide.analysis.reliability.jobs.SysCallAnalysisJobConf;
import eu.qimpress.samm.usagemodel.SystemCall;
import eu.qimpress.samm.usagemodel.UsageScenario;
import eu.qimpress.transformations.common.jobs.LoadResultsModelJob;
import eu.qimpress.transformations.common.jobs.LoadSAMMIntoBlackboardJob;
import eu.qimpress.transformations.common.jobs.PrepareResultsBlackboardPartionJob;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class ReliabilityLaunchConfigurationDelegate
extends AbstractWorkflowBasedLaunchConfigurationDelegate<ReliabilityConfiguration, BlackboardBasedWorkflow<MDSDBlackboard>> {
    private static final String LOG_PATTERN = "%-5p: %m\n";
    private Logger logger = Logger.getLogger(AbstractWorkflowBasedLaunchConfigurationDelegate.class);

    protected IJob createWorkflowJob(ReliabilityConfiguration config, ILaunch launch) throws CoreException {
        OrderPreservingBlackboardCompositeJob rootJob = new OrderPreservingBlackboardCompositeJob();
        rootJob.setName("Reliability Analysis Main Task");
        rootJob.add((IJob)new LoadSAMMIntoBlackboardJob(config.getAlternative()));
        rootJob.add((IJob)new PrepareResultsBlackboardPartionJob());
        rootJob.add((IJob)new LoadResultsModelJob(config.getAlternative()));
        this.logger.debug((Object)"Retrieving usage scenario to create SystemCall Analysis Jobs...");
        ArrayList<SysCallAnalysisJob> sysCallJobs = new ArrayList<SysCallAnalysisJob>();
        UsageScenario scenario = config.getUsageScenario();
        for (SystemCall sysCall : scenario.getSystemCalls()) {
            try {
                this.logger.debug((Object)("Creating SystemCall Analysis Job for System Call " + sysCall.getId()));
                SysCallAnalysisJob sysCallJob = new SysCallAnalysisJob(this.deriveSysCallAnalysisJobConf(config, scenario, sysCall));
                sysCallJobs.add(sysCallJob);
                rootJob.add((IJob)sysCallJob);
            }
            catch (InvalidWorkflowJobConfiguration e) {
                this.throwCoreException(e.getMessage());
            }
        }
        this.logger.debug((Object)"All SystemCall Analysis Jobs have been created...");
        this.logger.debug((Object)"Creating job to fill results model with analysis results...");
        FillResultsModelJob frmJob = new FillResultsModelJob(this.deriveFillResultsModelJobConf(config, sysCallJobs));
        rootJob.add((IJob)frmJob);
        this.logger.debug((Object)"Creating job to save results model with analysis results...");
        rootJob.add((IJob)new SavePartitionToDiskJob("eu.qimpress.results.partition"));
        return rootJob;
    }

    private FillResultsModelJobConf deriveFillResultsModelJobConf(ReliabilityConfiguration config, List<SysCallAnalysisJob> sysCallJobs) {
        FillResultsModelJobConf conf = new FillResultsModelJobConf();
        conf.setReliabilityConf(config);
        conf.setSysCallAnalysisJobs(sysCallJobs);
        conf.setSammModelLocation(new ModelLocation("eu.qimpress.samm.partition", config.getModelURI(config.getSammModel())));
        conf.setUsageModelLocation(new ModelLocation("eu.qimpress.samm.partition", config.getModelURI(config.getUsageProfilesModel())));
        conf.setResultsModelLocation(new ModelLocation("eu.qimpress.results.partition", config.getModelURI(config.getResultsModel())));
        return conf;
    }

    private SysCallAnalysisJobConf deriveSysCallAnalysisJobConf(ReliabilityConfiguration config, UsageScenario scenario, SystemCall sysCall) {
        SysCallAnalysisJobConf conf = new SysCallAnalysisJobConf();
        conf.setDefaults();
        conf.setReliabilityConf(config);
        conf.setUsageScenarioId(scenario.getId());
        conf.setUsageScenarioName(scenario.getName());
        conf.setSyscallId(sysCall.getId());
        conf.setSyscallName(sysCall.getName());
        return conf;
    }

    protected UIBasedWorkflow<MDSDBlackboard> createWorkflow(ReliabilityConfiguration workflowConfiguration, IProgressMonitor monitor, ILaunch launch) throws CoreException {
        return new UIBasedWorkflow(this.createWorkflowJob(workflowConfiguration, launch), monitor, this.createExcpetionHandler(workflowConfiguration.isInteractive()), (Blackboard)new MDSDBlackboard());
    }

    protected ReliabilityConfiguration deriveConfiguration(ILaunchConfiguration configuration, String mode) throws CoreException {
        ReliabilityConfiguration config = new ReliabilityConfiguration();
        config.initializeFrom(configuration);
        if (!config.isValid()) {
            this.throwCoreException(config.getErrorMessage());
        }
        return config;
    }

    protected ArrayList<LoggerAppenderStruct> setupLogging(Level logLevel) throws CoreException {
        ArrayList<LoggerAppenderStruct> loggerList = new ArrayList<LoggerAppenderStruct>();
        loggerList.add(this.setupLogger("de.uka.ipd.sdq.workflow", logLevel, LOG_PATTERN));
        loggerList.add(this.setupLogger("eu.qimpress.ide.analysis.reliability.jobs", logLevel, LOG_PATTERN));
        loggerList.add(this.setupLogger("eu.qimpress.ide.analysis.realiability.jobs.acceleo", logLevel, LOG_PATTERN));
        loggerList.add(this.setupLogger("eu.qimpress.ide.analysis.realiability.jobs.prism", logLevel, LOG_PATTERN));
        return loggerList;
    }

    private void throwCoreException(String message) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "eu.qimpress.ide.realiability", 0, message, null));
    }
}

