/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.realiability.launch;

import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedRunConfiguration;
import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.samm.usagemodel.Usage;
import eu.qimpress.samm.usagemodel.UsageScenario;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;

public class ReliabilityConfiguration
extends AbstractWorkflowBasedRunConfiguration {
    public static String NO_VALUE = "";
    private static Map<String, String> modelFriendlyNames = new HashMap<String, String>();
    private static final String RESULTS_MODEL_EXT = "samm_resultmodel";
    private String alternativeId;
    private String usageScenarioId;

    static {
        modelFriendlyNames.put("samm_repository", "Repository");
        modelFriendlyNames.put("samm_servicearchitecturemodel", "Service Architecture");
        modelFriendlyNames.put("samm_usagemodel", "Usage Profile");
        modelFriendlyNames.put("samm_seff", "SEFF Behavioral");
        modelFriendlyNames.put("samm_qosannotation", "Annotation");
    }

    public IQAlternative getAlternative() {
        return QImpressCore.getAlternativeById((String)this.alternativeId);
    }

    public UsageScenario getUsageScenario() {
        IQModel upModel = this.getUsageProfilesModel();
        try {
            Usage usage = (Usage)upModel.getTopLevelEObject();
            for (UsageScenario us : usage.getUsageScenarios()) {
                if (!us.getId().equals(this.usageScenarioId)) continue;
                return us;
            }
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public String getAlternativeId() {
        return this.alternativeId;
    }

    public void setAlternativeId(String alternativeId) {
        this.alternativeId = alternativeId;
    }

    public String getUsageScenarioId() {
        return this.usageScenarioId;
    }

    public void setUsageScenarioId(String usageScenarioId) {
        this.usageScenarioId = usageScenarioId;
    }

    public void resetAlernative() {
        this.alternativeId = NO_VALUE;
        this.usageScenarioId = NO_VALUE;
    }

    public void resetUsageScenario() {
        this.usageScenarioId = NO_VALUE;
    }

    public boolean isValid() {
        return this.getErrorMessage() == null;
    }

    public String getErrorMessage() {
        if (this.getAlternative() == null) {
            return "No alternative specified.";
        }
        if (this.checkModelAvailability(this.getRepositoryModel())) {
            return this.buildModelErrorMessage("samm_repository");
        }
        if (this.checkModelAvailability(this.getAnnotationsModel())) {
            return this.buildModelErrorMessage("samm_qosannotation");
        }
        if (this.checkModelAvailability(this.getUsageProfilesModel())) {
            return this.buildModelErrorMessage("samm_usagemodel");
        }
        if (this.checkModelAvailability(this.getSeffBehavioralModel())) {
            return this.buildModelErrorMessage("samm_seff");
        }
        if (this.checkModelAvailability(this.getSammModel())) {
            return this.buildModelErrorMessage("samm_servicearchitecturemodel");
        }
        if (this.getUsageScenario() == null) {
            return "No usage profile selected";
        }
        IFolder outputFolder = this.getOutputFolder();
        if (outputFolder == null) {
            return "Invalid output folder specified.";
        }
        return null;
    }

    private boolean checkModelAvailability(IQModel model) {
        IResource modelRes;
        IResource iResource = modelRes = model == null ? null : model.getCorrespondingResource();
        return modelRes == null || !(modelRes instanceof IFile) || !modelRes.isAccessible();
    }

    private String buildModelErrorMessage(String modelType) {
        return "Invalid alternative selected : " + modelFriendlyNames.get(modelType) + " model not available.";
    }

    public IQModel getRepositoryModel() {
        return this.getModelByType("samm_repository");
    }

    public IQModel getAnnotationsModel() {
        return this.getModelByType("samm_qosannotation");
    }

    public IQModel getUsageProfilesModel() {
        return this.getModelByType("samm_usagemodel");
    }

    public IQModel getSeffBehavioralModel() {
        return this.getModelByType("samm_seff");
    }

    public IQModel getSammModel() {
        return this.getModelByType("samm_servicearchitecturemodel");
    }

    public IQModel getResultsModel() {
        try {
            return this.getAlternative().getRepository().getResultModel();
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }

    public URI getModelURI(IQModel model) {
        return URI.createFileURI((String)model.getCorrespondingResource().getLocation().toString());
    }

    public IQModel getModelByType(String modelExtension) {
        IQAlternative alternative = this.getAlternative();
        if (alternative != null) {
            IQModel[] iQModelArray = alternative.getModels();
            int n = iQModelArray.length;
            int n2 = 0;
            while (n2 < n) {
                IQModel model = iQModelArray[n2];
                if (model.getType().equals(modelExtension)) {
                    return model;
                }
                ++n2;
            }
        }
        return null;
    }

    public IFolder getOutputFolder() {
        IQAlternative alternative = this.getAlternative();
        if (alternative != null) {
            IFolder tempAltFolder = alternative.getAlternativeFolder().getFolder("tmp");
            IFolder outputFolder = tempAltFolder.getFolder("reliability-analysis");
            return outputFolder;
        }
        return null;
    }

    public void setDefaults() {
        this.alternativeId = NO_VALUE;
        this.usageScenarioId = NO_VALUE;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(VARIABLES.ALTERNATIVE_ID.toString(), this.alternativeId);
        configuration.setAttribute(VARIABLES.SCENARIO_ID.toString(), this.usageScenarioId);
    }

    public void initializeFrom(ILaunchConfiguration configuration) throws CoreException {
        this.alternativeId = configuration.getAttribute(VARIABLES.ALTERNATIVE_ID.toString(), NO_VALUE);
        this.usageScenarioId = configuration.getAttribute(VARIABLES.SCENARIO_ID.toString(), NO_VALUE);
    }

    public static enum VARIABLES {
        ALTERNATIVE_ID,
        SCENARIO_ID;

    }
}

