/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.realiability.jobs.acceleo;

import de.uka.ipd.sdq.workflow.IJobWithResult;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import eu.qimpress.ide.analysis.realiability.jobs.acceleo.AcceleoTransformationJobConf;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.acceleo.engine.event.AcceleoTextGenerationEvent;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.service.AcceleoService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;

public class AcceleoTransformationJob
implements IJobWithResult<Set<File>> {
    private static final String JOB_NAME = "Perform Acceleo M2T transformation";
    private static final Logger logger = Logger.getLogger(AcceleoTransformationJob.class);
    private static final String GENERATOR_METHOD_NAME = "doGenerate";
    private Set<File> result = new HashSet<File>();
    private AcceleoTransformationJobConf configuration;

    public AcceleoTransformationJob(AcceleoTransformationJobConf configuration) {
        this.configuration = configuration;
    }

    public Set<File> getResult() {
        return this.result;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        Set<String> result = this.runTransformation(monitor);
        logger.debug((Object)"Generated files are :");
        for (String filePath : result) {
            logger.debug((Object)("* " + filePath));
        }
        for (String filePath : result) {
            this.result.add(new File(filePath));
        }
    }

    private Set<String> runTransformation(IProgressMonitor monitor) throws JobFailedException {
        Method doGenerateMethod;
        Object generator;
        logger.info((Object)"Starting Transformation...");
        logger.debug((Object)"Creating a generator class instance...");
        Class<?> genClass = this.configuration.getAcceleoGeneratorClass();
        try {
            Constructor<?> constr = genClass.getConstructor(URI.class, File.class, List.class);
            generator = constr.newInstance(this.configuration.getInputModel(), new File(this.configuration.getOutputFolder().getLocation().toString()), this.configuration.getArguments());
        }
        catch (Exception e) {
            throw new JobFailedException("Unable to instantiate generator class.", (Throwable)e);
        }
        try {
            Class[] params = new Class[]{Monitor.class};
            doGenerateMethod = genClass.getMethod(GENERATOR_METHOD_NAME, params);
        }
        catch (Exception e) {
            throw new JobFailedException("Invalid generator class.", (Throwable)e);
        }
        logger.debug((Object)"Attaching listener to AcceleoService...");
        AcceleoTextGenerationListener l = new AcceleoTextGenerationListener();
        AcceleoService.addListener((IAcceleoTextGenerationListener)l);
        logger.debug((Object)"Invoking transformation...");
        try {
            doGenerateMethod.invoke(generator, BasicMonitor.toMonitor((IProgressMonitor)monitor));
        }
        catch (Exception e) {
            throw new JobFailedException("Unable to execute tranformation.", (Throwable)e);
        }
        logger.debug((Object)"Detaching listener to AcceleoService...");
        AcceleoService.removeListener((IAcceleoTextGenerationListener)l);
        return l.generatedFiles;
    }

    public String getName() {
        return JOB_NAME;
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    private static class AcceleoTextGenerationListener
    implements IAcceleoTextGenerationListener {
        private Set<String> generatedFiles = new HashSet<String>();

        private AcceleoTextGenerationListener() {
        }

        public void textGenerated(AcceleoTextGenerationEvent event) {
        }

        public void filePathComputed(AcceleoTextGenerationEvent event) {
            this.generatedFiles.add(event.getText());
        }
    }
}

