/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanediting.listeners;

import de.fzi.kamp.service.commands.EditTimeEffortCommand;
import de.fzi.kamp.service.maineditor.ICommandHandler;
import de.fzi.maintainabilitymodel.workplan.Activity;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class EditableTimeEffortModifyListener
implements ModifyListener {
    private Activity activity;
    private Text text;
    private Display display;
    private TreeViewer treeViewer;
    private TreeItem item;
    private ICommandHandler commandHandler;
    private List<Object> itemList;

    public EditableTimeEffortModifyListener(Activity activity, Text text, Display display, TreeViewer treeViewer, TreeItem item, ICommandHandler commandHandler) {
        this.activity = activity;
        this.text = text;
        this.display = display;
        this.treeViewer = treeViewer;
        this.item = item;
        this.itemList = new ArrayList<Object>();
        this.commandHandler = commandHandler;
    }

    public void modifyText(ModifyEvent e) {
        StringBuffer buffer = new StringBuffer(this.text.getText());
        int index = buffer.indexOf(",");
        if (index > -1) {
            buffer.setCharAt(index, '.');
        }
        Double value = 0.0;
        try {
            value = Double.parseDouble(buffer.toString());
            this.text.setForeground(new Color((Device)this.display, 0, 0, 0));
            this.text.setToolTipText(null);
        }
        catch (Exception exception) {
            this.text.setToolTipText("No correct time value");
            this.text.setForeground(new Color((Device)this.display, 255, 0, 0));
        }
        EditTimeEffortCommand command = new EditTimeEffortCommand(this.activity, value);
        this.commandHandler.handleCommand((Command)command);
        Object[] elementsToUpdate = this.getItemsToUpdate(this.item);
        if (elementsToUpdate != null) {
            this.treeViewer.update(elementsToUpdate, new String[]{"Accumulated Effort"});
        }
        this.itemList = new ArrayList<Object>();
    }

    private Object[] getItemsToUpdate(TreeItem item) {
        TreeItem parentItem = item.getParentItem();
        if (parentItem != null) {
            this.getItemsToUpdate(parentItem);
        }
        this.itemList.add(item.getData());
        return this.itemList.toArray();
    }
}

