/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanderivation.wizard.initialderivation;

import de.fzi.kamp.service.workplanmanagement.WorkplanDerivationManager;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.data.InterfacePortSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.data.InterfaceSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.listeners.CheckBoxListenerInterfacePortIfInterfaceBefore;
import de.fzi.kamp.ui.workplanderivation.listeners.InterfacePortCheckBoxListener;
import de.fzi.kamp.ui.workplanderivation.listeners.InterfacePortComboListener;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.DeriveWorkPlanWizard;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectComponentActivitiesWizardPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectInterfacesPage;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractInterfacePort;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SelectInterfacePortPage
extends WizardPage {
    private CompositeTaskDerivationContainer workplanContainer;
    private WorkplanDerivationManager workplanDerivationManager;
    private SurfaceFactory factory;
    private Composite container;
    private Map<InterfacePortSelectionContainer, InterfacePortSelectionContainerDecorator> container2decoratorMap;

    public SelectInterfacePortPage(CompositeTaskDerivationContainer workplanContainer) {
        super("Derive Work Plan");
        this.setTitle("Select Interface Port Activities");
        this.setDescription("Please check the interface ports which are affected\nby the changes in the previously selected components.");
        this.workplanContainer = workplanContainer;
        this.workplanDerivationManager = new WorkplanDerivationManager(workplanContainer);
        this.factory = new SurfaceFactory();
        this.container2decoratorMap = new HashMap<InterfacePortSelectionContainer, InterfacePortSelectionContainerDecorator>();
    }

    public void createControl(Composite parent) {
        this.container = this.factory.createCompositeOrGroup(parent, 1, 4, 1, 0, false, 0, 0);
        this.setControl((Control)this.container);
        if (this.getPreviousPage() instanceof SelectInterfacesPage) {
            if (this.workplanDerivationManager.getSelectedInterfaces().size() > 0) {
                this.createTablesForInterfaces();
            }
        } else if (this.workplanDerivationManager.getSelectedComponents().size() > 0) {
            this.createTableForComponents();
        }
        this.getShell().pack();
    }

    public void createTableForComponents() {
        EList lastShownComponentContainer = this.workplanContainer.getLastShownComponentContainers();
        if (lastShownComponentContainer.size() > 0) {
            this.createTableForComponents((List<ComponentSelectionContainer>)lastShownComponentContainer);
        }
    }

    public void createTablesForInterfaces() {
        EList lastShownInterfaceContainers = this.workplanContainer.getLastShownInterfaceContainers();
        if (lastShownInterfaceContainers.size() > 0) {
            this.createTableForInterface((List<InterfaceSelectionContainer>)lastShownInterfaceContainers);
        }
    }

    private void createTableForComponents(List<ComponentSelectionContainer> selectedContainer) {
        Table table = this.factory.createTable(this.container, 1, new String[]{"!", "Component Name", "Interface Port", "Type", "Basic Activity"}, 4, true);
        this.factory.setGrabVerticalForGridData((Control)table, true, 4);
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 25;
            }
        });
        for (ComponentSelectionContainer componentContainer : selectedContainer) {
            if (!componentContainer.isSelected()) continue;
            TableItem item = new TableItem(table, 0);
            item.setText(1, componentContainer.getComponenttype().getName());
            switch (componentContainer.getBasicActivity()) {
                case ADD: {
                    item.setText(4, BasicActivity.ADD.toString());
                    break;
                }
                case CHANGE: {
                    item.setText(4, BasicActivity.CHANGE.toString());
                    break;
                }
                case REMOVE: {
                    item.setText(4, BasicActivity.REMOVE.toString());
                    break;
                }
                default: {
                    item.setText(4, "");
                }
            }
            LinkedList<AbstractInterfacePort> alreadyDisplayed = new LinkedList<AbstractInterfacePort>();
            for (InterfacePortSelectionContainer interfacePortContainer : componentContainer.getRefinements()) {
                if (alreadyDisplayed.contains(interfacePortContainer.getInterfaceport())) continue;
                alreadyDisplayed.add(interfacePortContainer.getInterfaceport());
                this.createItemForInterfacePort(interfacePortContainer, table, componentContainer.getBasicActivity(), false);
            }
        }
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
        table.pack();
        this.setPageComplete(this.checkedAndSelected());
    }

    private void createTableForInterface(List<InterfaceSelectionContainer> interfaceContainers) {
        Table table = this.factory.createTable(this.container, 1, new String[]{"!", "Component Name", "Interface Port", "Type", "Basic Activity"}, 4, true);
        this.factory.setGrabVerticalForGridData((Control)table, true, 4);
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 25;
            }
        });
        for (InterfaceSelectionContainer ifaceContainer : interfaceContainers) {
            if (!ifaceContainer.isSelected()) continue;
            for (InterfacePortSelectionContainer interfacePort : ifaceContainer.getFollowups()) {
                this.createItemForInterfacePort(interfacePort, table, ifaceContainer.getBasicActivity(), true);
            }
        }
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
        table.pack();
        this.setPageComplete(this.checkedAndSelected());
    }

    private void createItemForInterfacePort(InterfacePortSelectionContainer ifacePortContainer, Table table, BasicActivity basicActivity, boolean changeInterface) {
        TableItem itemForAssociatedInterface = new TableItem(table, 0);
        itemForAssociatedInterface.setFont(this.factory.getFontStyle().get("answerStyle"));
        if (!ifacePortContainer.getInterfaceport().getName().isEmpty()) {
            itemForAssociatedInterface.setText(2, ifacePortContainer.getInterfaceport().getName());
        }
        if (basicActivity != BasicActivity.REMOVE) {
            Button checkbox = new Button((Composite)table, 32);
            this.factory.setControlWithTableEditor(table, itemForAssociatedInterface, (Control)checkbox, 0);
            Combo combo = null;
            if (changeInterface) {
                combo = this.factory.createCombo(itemForAssociatedInterface, new String[]{BasicActivity.CHANGE.toString()}, table, 4);
            } else {
                if (basicActivity == BasicActivity.ADD) {
                    combo = this.factory.createCombo(itemForAssociatedInterface, new String[]{BasicActivity.ADD.toString()}, table, 4);
                }
                if (basicActivity == BasicActivity.CHANGE) {
                    combo = this.factory.createCombo(itemForAssociatedInterface, new String[]{BasicActivity.ADD.toString(), BasicActivity.CHANGE.toString(), BasicActivity.REMOVE.toString()}, table, 4);
                }
            }
            combo.setEnabled(false);
            this.factory.setControlWithTableEditor(table, itemForAssociatedInterface, (Control)combo, 4);
            if (ifacePortContainer.getInterfaceport().isRequired()) {
                itemForAssociatedInterface.setText(3, "required");
            } else {
                itemForAssociatedInterface.setText(3, "provided");
            }
            InterfacePortSelectionContainerDecorator decorator = this.createDecorator(ifacePortContainer, itemForAssociatedInterface, checkbox, combo);
            if (this.getPreviousPage() instanceof SelectComponentActivitiesWizardPage) {
                checkbox.addSelectionListener((SelectionListener)new InterfacePortCheckBoxListener(this, decorator));
            } else {
                checkbox.addSelectionListener((SelectionListener)new CheckBoxListenerInterfacePortIfInterfaceBefore(this, decorator));
            }
            combo.addSelectionListener((SelectionListener)new InterfacePortComboListener(this, decorator, changeInterface));
            this.checkWhetherAlreadyChosen(decorator);
        } else {
            Button placeboCheckbox = new Button((Composite)table, 32);
            placeboCheckbox.setEnabled(false);
            placeboCheckbox.setToolTipText("It is unnecessary to choose further activities if the parent is removed");
            this.factory.setControlWithTableEditor(table, itemForAssociatedInterface, (Control)placeboCheckbox, 0);
            Combo placeboCombo = new Combo((Composite)table, 8);
            placeboCombo.setText("Nothing to choose");
            placeboCombo.setEnabled(false);
            this.factory.setControlWithTableEditor(table, itemForAssociatedInterface, (Control)placeboCombo, 4);
            InterfacePortSelectionContainerDecorator decorator = this.createDecorator(ifacePortContainer, itemForAssociatedInterface, placeboCheckbox, placeboCombo);
            this.checkWhetherAlreadyChosen(decorator);
            this.checkedAndSelected();
        }
    }

    private InterfacePortSelectionContainerDecorator createDecorator(InterfacePortSelectionContainer ifaceContainer, TableItem itemForAssociatedInterface, Button checkbox, Combo combo) {
        InterfacePortSelectionContainerDecorator decorator = new InterfacePortSelectionContainerDecorator(ifaceContainer);
        this.container2decoratorMap.put(ifaceContainer, decorator);
        itemForAssociatedInterface.setData((Object)ifaceContainer);
        decorator.setCheckbox(checkbox);
        decorator.setCombo(combo);
        decorator.setTableItem(itemForAssociatedInterface);
        this.workplanDerivationManager.addShowedInterfacePort(ifaceContainer);
        return decorator;
    }

    public void disposeOfAll(Table table) {
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (table.getItemCount() > 0) {
                System.err.println("# of table items: " + table.getItemCount());
            } else {
                System.err.println("Keine Items vorhanden (was eigentlich nicht sein kann)");
            }
            if (item.getData() != null) {
                ((InterfaceSelectionContainerDecorator)item.getData()).getCheckbox().dispose();
                ((InterfaceSelectionContainerDecorator)item.getData()).getCombo().dispose();
            } else {
                table.removeAll();
            }
            ++n2;
        }
    }

    public boolean checkedAndSelected() {
        this.setErrorMessage(null);
        if (this.checkWhetherOnlyRemoveActions()) {
            return true;
        }
        List selectedItems = this.workplanDerivationManager.getSelectedInterfacePorts();
        if (selectedItems.size() < 1) {
            return false;
        }
        boolean checkedAndSelected = true;
        for (InterfacePortSelectionContainer abstractContainer : selectedItems) {
            if (abstractContainer.getBasicActivity() == BasicActivity.REMOVE) {
                return true;
            }
            InterfacePortSelectionContainerDecorator decorator = this.container2decoratorMap.get(abstractContainer);
            if (abstractContainer.getBasicActivity() == null) {
                decorator.getTableItem().setBackground(4, new Color((Device)this.getContainer().getShell().getDisplay(), 255, 0, 0));
                this.setErrorMessage("If you check a component, you have to chose a basic activity");
                checkedAndSelected = false;
                continue;
            }
            decorator.getTableItem().setBackground(4, new Color((Device)this.getContainer().getShell().getDisplay(), 255, 255, 255));
        }
        return checkedAndSelected;
    }

    private boolean checkWhetherOnlyRemoveActions() {
        for (ComponentSelectionContainer container : this.workplanContainer.getLastShownComponentContainers()) {
            if (container.getBasicActivity() == BasicActivity.REMOVE || container.getBasicActivity() == null) continue;
            return false;
        }
        for (ComponentSelectionContainer container : this.workplanContainer.getLastShownInterfaceContainers()) {
            if (container.getBasicActivity() == BasicActivity.REMOVE || container.getBasicActivity() == null) continue;
            return false;
        }
        return true;
    }

    private void checkWhetherAlreadyChosen(InterfacePortSelectionContainerDecorator portDecorator) {
        if (portDecorator.getContainer().isSelected()) {
            portDecorator.getCheckbox().setSelection(true);
            portDecorator.getCheckbox().setEnabled(false);
            if (this.getPreviousPage() instanceof SelectComponentActivitiesWizardPage) {
                portDecorator.getCombo().setText(portDecorator.getCombo().getItem(((DeriveWorkPlanWizard)this.getWizard()).getSelectionIndex((AbstractContainer)portDecorator.getContainer())));
            } else {
                portDecorator.getCombo().setText(portDecorator.getCombo().getItem(0));
            }
        }
    }
}

