/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation;

import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.service.workplanmanagement.WorkplanDerivationManager;
import de.fzi.kamp.ui.general.AbstractWizard;
import de.fzi.kamp.ui.maineditor.page.CentralEditorPage;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.FurtherForkPage;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.SelectElementTypesPage;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.Task;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class FurtherDerivationWizard
extends AbstractWizard
implements IWizard {
    public static final int NORMAL_DERIVATION = 0;
    public static final int COMPONENT_DERIVATION = 1;
    public static final int INTERFACE_DERIVATION = 2;
    public static final int DATATYPE_DERIVATION = 3;
    private CompositeTaskDerivationContainer compositeTaskContainer;
    private WorkplanDerivationManager workplanManager;
    private SelectElementTypesPage selectionPage;
    private FurtherForkPage forkPage;
    private IMainEditor editor;
    private Tree workplanTree;
    private Activity activity;
    private List<AbstractContainer> input;

    public FurtherDerivationWizard(Tree workplanTree, IMainEditor editor) {
        this.editor = editor;
        this.selectionPage = new SelectElementTypesPage();
        this.forkPage = new FurtherForkPage(this.selectionPage);
        this.workplanTree = workplanTree;
        TreeItem item = this.workplanTree.getSelection()[0];
        this.activity = (Activity)item.getData();
        if (workplanTree.getData() instanceof Workplan) {
            CompositeTask compositeTask = this.getCompositeTask(this.activity);
            this.compositeTaskContainer = this.getContainerForCompositeTask(compositeTask);
            this.workplanManager = new WorkplanDerivationManager(this.compositeTaskContainer);
        }
        this.input = new ArrayList<AbstractContainer>();
        this.input.add(this.getSelectedContainer());
    }

    @Override
    public boolean performFinish() {
        this.selectionPage.assignChanges(this.selectionPage.getCurrentTree().getItems());
        TreeViewer treeViewer = ((CentralEditorPage)this.editor.getCentralPage()).getWorkplanLayer().getAdapter().getTreeViewer(this.workplanTree);
        treeViewer.refresh();
        return true;
    }

    @Override
    public void addPages() {
        if (this.activity instanceof CompositeTask) {
            this.addPage((IWizardPage)this.forkPage);
        }
        this.addPage((IWizardPage)this.selectionPage);
        this.setWindowTitle("Select further Work Activities");
    }

    public AbstractContainer getSelectedContainer() {
        if (this.activity instanceof CompositeTask) {
            return this.compositeTaskContainer;
        }
        return this.workplanManager.getContainerForTask(this.activity);
    }

    public Task getSelectedTask() {
        return (Task)this.workplanTree.getSelection()[0].getData();
    }

    public IMainEditor getMainEditor() {
        return this.editor;
    }

    public CompositeTaskDerivationContainer getContainerForCompositeTask(CompositeTask compositeTask) {
        for (CompositeTaskDerivationContainer container : FurtherDerivationWizard.deriveSurroundingWorkplan(compositeTask).getCompositetaskderivationcontainer()) {
            if (!container.getActivity().equals(compositeTask)) continue;
            return container;
        }
        return null;
    }

    private static Workplan deriveSurroundingWorkplan(CompositeTask compositeTask) {
        if (compositeTask.eContainer() instanceof Workplan) {
            return (Workplan)compositeTask.eContainer();
        }
        if (compositeTask.eContainer() instanceof CompositeTask) {
            return FurtherDerivationWizard.deriveSurroundingWorkplan((CompositeTask)compositeTask.eContainer());
        }
        return null;
    }

    public CompositeTask getCompositeTask(Activity activity) {
        Activity currentActivity = activity;
        while (!(currentActivity instanceof CompositeTask)) {
            currentActivity = (Activity)currentActivity.eContainer();
        }
        return (CompositeTask)currentActivity;
    }

    public List<AbstractContainer> getInput() {
        return this.input;
    }
}

