/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.preparation.listeners;

import ResultModel.AlternativeEvaluation;
import ResultModel.MaintainabilityPredictionResult;
import ResultModel.ResultModelFactory;
import ResultModel.ResultRepository;
import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ExportToResultmodelListener
extends SelectionAdapter {
    private AnalysisManager analysisManager;
    private ResourceSet resourceSet;
    private Logger logger = Logger.getRootLogger();
    private Shell shell;

    public ExportToResultmodelListener(AnalysisManager analysisManager, ResourceSet resourceSet, Shell shell) {
        this.analysisManager = analysisManager;
        this.resourceSet = resourceSet;
        this.shell = shell;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        ResultRepository resultRoot = ResultModelFactory.eINSTANCE.createResultRepository();
        Map<ArchitecturalAlternative, List<EffortAnalysisInstance>> architectureToInstancesMap = this.getUsedArchitecturalAlternatives();
        for (ArchitecturalAlternative alternative : architectureToInstancesMap.keySet()) {
            AlternativeEvaluation alternativeEvaluation = ResultModelFactory.eINSTANCE.createAlternativeEvaluation();
            alternativeEvaluation.setName(alternative.getName());
            resultRoot.getAnalysisRuns().add((Object)alternativeEvaluation);
            MaintainabilityPredictionResult maintPredictionResult = ResultModelFactory.eINSTANCE.createMaintainabilityPredictionResult();
            maintPredictionResult.getEffortanalysisinstances().addAll((Collection)architectureToInstancesMap.get(alternative));
            alternativeEvaluation.getAnalysisResults().add((Object)maintPredictionResult);
        }
        String fullPath = this.getSAMMUri();
        if (!fullPath.equals("")) {
            this.exportToXML(fullPath, resultRoot);
            try {
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
            }
            catch (CoreException exception) {
                this.logger.error((Object)exception.getMessage());
                exception.printStackTrace();
            }
        }
        super.widgetSelected(e);
    }

    public void exportToXML(String pathName, ResultRepository resultRoot) {
        Resource resource = this.resourceSet.createResource(URI.createFileURI((String)pathName));
        resource.getContents().add((Object)resultRoot);
        Map saveOptions = ((XMLResource)resource).getDefaultSaveOptions();
        saveOptions.put("CONFIGURATION_CACHE", Boolean.TRUE);
        saveOptions.put("USE_CACHED_LOOKUP_TABLE", new ArrayList());
        try {
            resource.save(saveOptions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getSAMMUri() {
        FileDialog dialog = new FileDialog(this.shell);
        dialog.setFileName("sample");
        dialog.setFilterExtensions(new String[]{"*.samm_resultmodel"});
        dialog.open();
        String filePath = dialog.getFilterPath();
        String fileName = dialog.getFileName();
        if (filePath.equals("")) {
            return "";
        }
        if (!fileName.contains(".samm_resultmodel")) {
            return String.valueOf(filePath) + "\\" + fileName + ".samm_resultmodel";
        }
        MessageBox box = new MessageBox(this.shell, 196);
        box.setMessage("The file you wanted to create already exists. Override?");
        int response = box.open();
        if (response == 64) {
            return String.valueOf(filePath) + "\\" + fileName;
        }
        return "";
    }

    private Map<ArchitecturalAlternative, List<EffortAnalysisInstance>> getUsedArchitecturalAlternatives() {
        HashMap<ArchitecturalAlternative, List<EffortAnalysisInstance>> alternativeToInstancesMap = new HashMap<ArchitecturalAlternative, List<EffortAnalysisInstance>>();
        for (EffortAnalysisInstance occuringInstance : this.analysisManager.getAnalysisInstanceManager().getAnalysisInstances()) {
            if (alternativeToInstancesMap.containsKey(occuringInstance.getArchitecturalalternative())) {
                ((List)alternativeToInstancesMap.get(occuringInstance.getArchitecturalalternative())).add(occuringInstance);
                continue;
            }
            LinkedList<EffortAnalysisInstance> instanceList = new LinkedList<EffortAnalysisInstance>();
            instanceList.add(occuringInstance);
            alternativeToInstancesMap.put(occuringInstance.getArchitecturalalternative(), instanceList);
        }
        return alternativeToInstancesMap;
    }
}

