/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.preparation.dialogs;

import de.fzi.maintainabilitymodel.architecturemodel.AbstractArchitectureModel;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ArchitectureAlternativeLoadDialog
extends Dialog {
    private List<AbstractArchitectureModel> architectureModelList;
    private List<AbstractArchitectureModel> selectedModels;
    private ArchitecturalAlternative alternative;
    private Composite comp;
    private Combo combo;
    private Text nameText;
    private Text descriptionText;
    private boolean edit;

    public ArchitectureAlternativeLoadDialog(Shell parentShell, List<AbstractArchitectureModel> architectureModelList, List<AbstractArchitectureModel> selectedModels, boolean edit, ArchitecturalAlternative alternative) {
        super(parentShell);
        this.architectureModelList = architectureModelList;
        this.selectedModels = selectedModels;
        this.edit = edit;
        this.alternative = alternative;
    }

    public void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.edit) {
            shell.setText("Edit Architectural Alternative");
        } else {
            shell.setText("Choose Architectural Alternatives to load");
        }
        Rectangle rec = shell.getDisplay().getBounds();
        int shellWidth = 500;
        int shellHeight = 220;
        int indentionLeft = (rec.width - shellWidth) / 2;
        int indentionTop = (rec.height - shellHeight) / 2;
        shell.setBounds(indentionLeft, indentionTop, shellWidth, shellHeight);
    }

    public Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.comp = (Composite)super.getDialogArea();
        this.setLayout(this.comp);
        if (!this.edit) {
            this.createUnderlyingModelCombo();
        } else {
            this.createSelectedModelLabel();
        }
        if (this.alternative != null) {
            this.createNamePart(this.alternative.getName());
            this.createDescriptionPart(this.alternative.getDescription());
        } else {
            this.createNamePart("");
            this.createDescriptionPart("");
        }
        return control;
    }

    public void okPressed() {
        if (!this.edit) {
            this.setNewAlternative();
        } else {
            this.setAlternativeAttributes();
        }
        super.okPressed();
    }

    public void setLayout(Composite comp) {
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        comp.setLayout((Layout)gl);
    }

    public void createUnderlyingModelCombo() {
        Label label = new Label(this.comp, 0);
        label.setText("Select architecture model: ");
        this.combo = new Combo(this.comp, 8);
        this.setLayoutData(this.combo);
        for (AbstractArchitectureModel architectureModel : this.architectureModelList) {
            this.combo.add(architectureModel.getName());
        }
    }

    public void createNamePart(String oldtext) {
        Label nameLabel = new Label(this.comp, 0);
        nameLabel.setText("Name: ");
        this.nameText = new Text(this.comp, 2048);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.nameText.setLayoutData((Object)gd);
        if (oldtext != null) {
            this.nameText.setText(oldtext);
        }
    }

    public void createDescriptionPart(String oldtext) {
        Label descriptionLabel = new Label(this.comp, 0);
        descriptionLabel.setText("Description : ");
        this.descriptionText = new Text(this.comp, 2048);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.descriptionText.setLayoutData((Object)gd);
        if (oldtext != null) {
            this.descriptionText.setText(oldtext);
        }
    }

    public void createSelectedModelLabel() {
        Label label = new Label(this.comp, 0);
        if (this.alternative != null && this.alternative.getArchitecturemodel() != null) {
            String archiAltBase = this.alternative.getArchitecturemodel().getName();
            label.setText("The architecture model underlying this\narchitectural alternative is: " + archiAltBase);
        }
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
    }

    public void setNewAlternative() {
        int selectedItemIndex = this.combo.getSelectionIndex();
        if (selectedItemIndex >= 0) {
            this.selectedModels.add(this.architectureModelList.get(selectedItemIndex));
            if (this.nameText.getText().isEmpty()) {
                this.alternative.setName(this.architectureModelList.get(selectedItemIndex).getName());
            } else {
                this.alternative.setName(this.nameText.getText());
            }
            this.alternative.setDescription(this.descriptionText.getText());
        } else {
            this.combo.setToolTipText("Please choose a model!");
            this.combo.setBackground(new Color((Device)this.comp.getDisplay(), 255, 0, 0));
        }
    }

    public void setAlternativeAttributes() {
        if (!this.nameText.getText().isEmpty()) {
            this.alternative.setName(this.nameText.getText());
        }
        if (!this.descriptionText.getText().isEmpty()) {
            this.alternative.setDescription(this.descriptionText.getText());
        }
    }

    private void setLayoutData(Combo combo) {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        combo.setLayoutData((Object)gd);
    }

    public Composite getComposite() {
        return this.comp;
    }
}

