/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.preparation.dialogs;

import de.fzi.maintainabilitymodel.workplan.ChangeRequest;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddChangeRequestDialog
extends Dialog {
    private ChangeRequest changeRequest;
    private Composite area;
    private Text textName;
    private Text textDescription;
    private Label nameLabel;
    private Label descriptionLabel;
    private boolean edit;

    public AddChangeRequestDialog(Shell parentShell, ChangeRequest changeRequest, boolean edit) {
        super(parentShell);
        this.changeRequest = changeRequest;
        this.edit = edit;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (!this.edit) {
            shell.setText("Add Change Request");
        } else {
            shell.setText("Edit Change Request");
        }
        Rectangle rec = shell.getDisplay().getBounds();
        int shellWidth = 280;
        int shellHeight = 140;
        int indentionLeft = (rec.width - shellWidth) / 2;
        int indentionTop = (rec.height - shellHeight) / 2;
        shell.setBounds(indentionLeft, indentionTop, shellWidth, shellHeight);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.area = (Composite)this.getDialogArea();
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.area.setLayout((Layout)gl);
        this.createNamePart();
        this.createDescriptionPart();
        return control;
    }

    protected void okPressed() {
        String name = this.textName.getText();
        String description = this.textDescription.getText();
        if (name != null && !name.isEmpty()) {
            this.changeRequest.setName(name);
            this.changeRequest.setDescription(description);
            super.okPressed();
        }
    }

    protected void createNamePart() {
        this.nameLabel = new Label(this.area, 0);
        this.nameLabel.setText("Name: ");
        this.textName = new Text(this.area, 2052);
        this.textName.setText(this.changeRequest.getName());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textName.setLayoutData((Object)gd);
    }

    protected void createDescriptionPart() {
        this.descriptionLabel = new Label(this.area, 0);
        this.descriptionLabel.setText("Description: ");
        this.textDescription = new Text(this.area, 2052);
        this.textDescription.setText(this.changeRequest.getDescription());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textDescription.setLayoutData((Object)gd);
    }
}

