/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.maineditor.stacklayers;

import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.maineditor.MainEditorUI;
import de.fzi.kamp.ui.preparation.adapter.ArchitectureAlternativesContentAdapter;
import de.fzi.kamp.ui.preparation.adapter.ChangeRequestContentAdapter;
import de.fzi.kamp.ui.preparation.listeners.GoToAnalysisInstancePageListener;
import de.fzi.kamp.ui.preparation.listeners.MapElementsToTeamsButtonlistener;
import de.fzi.kamp.ui.preparation.listeners.PreparationAddChangeRequestListener;
import de.fzi.kamp.ui.preparation.listeners.PreparationEditAlternativeListener;
import de.fzi.kamp.ui.preparation.listeners.PreparationEditChangeRequestListener;
import de.fzi.kamp.ui.preparation.listeners.PreparationLoadSelectionListener;
import de.fzi.kamp.ui.preparation.listeners.PreparationRemoveArchitectureListener;
import de.fzi.kamp.ui.preparation.listeners.PreparationRemoveChangeRequestListener;
import de.fzi.kamp.ui.workplanediting.listeners.GoToWorkorganisationView;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class PreparationLayer {
    private static final String ARCHITECTURE_ALTERNATIVE_SECTION_HEADING = "Architecture Alternatives:";
    private static final String CHANGE_REQUEST_SECTION_HEADING = "Change Request Description:";
    private static final String TABLE_HEADING_NAME = "Name";
    private static final String TABLE_HEADING_DESCRIPTION = "Description";
    private static final String NAVIGATION_GROUP_TEXT = "Go to";
    private static final String[] ARCHI_ALT_BUTTONLABELS = new String[]{"Load", "Edit", "Remove", "Check Workorganisation Annotation"};
    private static final String[] CHANGE_REQUEST_BUTTONLABELS = new String[]{"Add", "Remove", "Edit"};
    private static final String[] NAVIGATION_BUTTON_LABELS = new String[]{"Analysis Overview", "Edit Workorganisation"};
    private Display display;
    private MainEditorUI mainEditorUI;
    private SurfaceFactory factory;

    public void setupPreparationLayer(IMainEditor mainEditor) {
        this.mainEditorUI = (MainEditorUI)mainEditor;
        this.display = this.mainEditorUI.getEditorSite().getShell().getDisplay();
        this.factory = new SurfaceFactory();
    }

    public void createPreparationPage(AnalysisManager analysisManager, IMainEditor mainEditor, ScrolledForm form) {
        this.setupPreparationLayer(mainEditor);
        this.createArchitectureAlternativePart(analysisManager, this.display, form);
        this.createChangeRequestPart(analysisManager, this.display, form);
        this.createNavigationButtons(form.getBody(), mainEditor);
    }

    private void createArchitectureAlternativePart(AnalysisManager analysisManager, Display display, ScrolledForm form) {
        Section section1 = this.factory.createSection(form.getBody(), ARCHITECTURE_ALTERNATIVE_SECTION_HEADING, 256, 2, true, display, 1);
        Composite sectionClient1 = this.factory.createCompositeForSection((Composite)section1, 2, 4, 1, 0, 15, 15, display);
        Table archiAltTable = this.factory.createTable(sectionClient1, 1, new String[]{TABLE_HEADING_NAME, TABLE_HEADING_DESCRIPTION}, 4, true);
        this.factory.setSizeForControl((Composite)archiAltTable, 300, 150, true);
        SelectionAdapter[] listenersAtlernativeButtons = new SelectionAdapter[]{new PreparationLoadSelectionListener(analysisManager), new PreparationEditAlternativeListener(archiAltTable, analysisManager), new PreparationRemoveArchitectureListener(analysisManager, archiAltTable), new MapElementsToTeamsButtonlistener(archiAltTable, analysisManager.getPreparationManager(), display, this.mainEditorUI)};
        analysisManager.getAnalysisModel().eAdapters().add((Object)new ArchitectureAlternativesContentAdapter(archiAltTable, analysisManager.getAnalysisModel()));
        this.factory.createVerticalButtonComposite(sectionClient1, 4, 4, ARCHI_ALT_BUTTONLABELS, 0, listenersAtlernativeButtons);
        section1.setClient((Control)sectionClient1);
    }

    private void createChangeRequestPart(AnalysisManager analysisManager, Display display, ScrolledForm form) {
        Section section2 = this.factory.createSection(form.getBody(), CHANGE_REQUEST_SECTION_HEADING, 256, 2, true, display, 1);
        Composite sectionClient2 = this.factory.createCompositeForSection((Composite)section2, 2, 4, 1, 0, 15, 15, display);
        Table changeReqTable = this.factory.createTable(sectionClient2, 1, new String[]{TABLE_HEADING_NAME, TABLE_HEADING_DESCRIPTION}, 4, true);
        this.factory.setSizeForControl((Composite)changeReqTable, 300, 150, true);
        SelectionAdapter[] listenersChangeButtons = new SelectionAdapter[]{new PreparationAddChangeRequestListener(changeReqTable, analysisManager), new PreparationRemoveChangeRequestListener(changeReqTable, analysisManager), new PreparationEditChangeRequestListener(changeReqTable, analysisManager)};
        this.factory.createVerticalButtonComposite(sectionClient2, 4, 4, CHANGE_REQUEST_BUTTONLABELS, 0, listenersChangeButtons);
        analysisManager.getAnalysisModel().eAdapters().add((Object)new ChangeRequestContentAdapter(changeReqTable, analysisManager.getAnalysisModel()));
        section2.setClient((Control)sectionClient2);
    }

    public void createNavigationButtons(Composite composite, IMainEditor mainEditor) {
        this.setupPreparationLayer(mainEditor);
        Group group = this.factory.createGroupWithWhiteBackgroundTableWrap(this.display, composite, NAVIGATION_GROUP_TEXT, 4, true, 2, 1);
        this.factory.createHorizontalButtonsForEclipseForm(this.display, (Composite)group, NAVIGATION_BUTTON_LABELS, new SelectionAdapter[]{new GoToAnalysisInstancePageListener(this.mainEditorUI), new GoToWorkorganisationView(this.mainEditorUI)}, 4, 4, false);
    }
}

