/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.maineditor.stacklayers;

import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.analysisoverview.adapters.AnalysisInstanceContentAdapter;
import de.fzi.kamp.ui.analysisoverview.adapters.SummaryTableContentAdapter;
import de.fzi.kamp.ui.analysisoverview.listeners.AnalysisInstanceAddSelectionListener;
import de.fzi.kamp.ui.analysisoverview.listeners.AnalysisInstanceRemoveArchitectureSelectionListener;
import de.fzi.kamp.ui.analysisoverview.providers.AnalysisInstanceConstants;
import de.fzi.kamp.ui.analysisoverview.providers.AnalysisInstanceContentProvider;
import de.fzi.kamp.ui.analysisoverview.providers.AnalysisInstanceLabelProvider;
import de.fzi.kamp.ui.analysisoverview.providers.SummaryTableContentProvider;
import de.fzi.kamp.ui.analysisoverview.providers.SummaryTableLabelProvider;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.preparation.listeners.ExportToResultmodelListener;
import de.fzi.kamp.ui.workplanediting.listeners.GoToPreparationPageListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class AnalysisInstanceLayer {
    private SurfaceFactory factory;
    private Composite comp;
    private Display display;
    private Table table;
    private AnalysisManager analysisManager;
    private IMainEditor mainEditorUI;
    private TableViewer tableViewer;

    public void createAnalysisInstancePage(AnalysisManager analysisManager, Display display, ScrolledForm form, IMainEditor mainEditorUI) {
        this.display = display;
        this.mainEditorUI = mainEditorUI;
        this.analysisManager = analysisManager;
        this.factory = new SurfaceFactory();
        this.comp = this.factory.createCompositeForEclipseForm(display, form.getBody(), 0, 128, true, 1, 2);
        this.createAnalysisInstancesTable();
        this.factory.setSizeForControl((Composite)this.table, 0, 300, false);
        Section section = this.createButtonSection();
        this.table.moveBelow((Control)section);
        this.createNavigationButton();
        this.createExportInResultModelButton();
        this.createSummaryTable(form);
    }

    private void createAnalysisInstancesTable() {
        this.table = this.factory.createTableForAnalysisInstanceLayer(this.display, this.comp, 67584, AnalysisInstanceConstants.getMainTableCaptions(), true, 128, 2);
        this.table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 25;
            }
        });
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new AnalysisInstanceContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AnalysisInstanceLabelProvider());
        this.tableViewer.setInput((Object)this.analysisManager.getAnalysisModel());
        this.analysisManager.getAnalysisModel().eAdapters().add((Object)new AnalysisInstanceContentAdapter(this.table, this.tableViewer, this.analysisManager.getAnalysisInstanceManager(), this.mainEditorUI));
        this.table.getColumn(4).setAlignment(0x1000000);
        this.setWorkComplexityColumnInvisible(this.table);
    }

    private void createSummaryTable(ScrolledForm form) {
        Section section = this.factory.createSection(this.comp, "Architecture Alternative Effort Summary", 256, 2, false, this.display, 2);
        section.setFont(this.factory.getFontStyle().get("answerStyle"));
        Table summaryTable = this.factory.createTableWithToolkit(this.display, (Composite)section, 65536, AnalysisInstanceConstants.getSummaryTableCaptions(), false, 16384, 1);
        summaryTable.setHeaderVisible(false);
        summaryTable.setLinesVisible(false);
        summaryTable.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 25;
            }
        });
        TableViewer viewer = new TableViewer(summaryTable);
        viewer.setContentProvider((IContentProvider)new SummaryTableContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new SummaryTableLabelProvider());
        viewer.setInput((Object)this.analysisManager.getAnalysisModel());
        this.factory.setSizeForControl((Composite)summaryTable, 0, 100, false);
        SummaryTableContentAdapter contentAdapter = new SummaryTableContentAdapter(summaryTable, viewer);
        this.analysisManager.getAnalysisModel().eAdapters().add((Object)contentAdapter);
        section.setClient((Control)summaryTable);
    }

    private Section createButtonSection() {
        Section section = this.factory.createSection(this.comp, "Analysis Instance", 256, 8, false, this.display, 2);
        section.setFont(this.factory.getFontStyle().get("answerStyle"));
        SelectionAdapter[] listenerArray = new SelectionAdapter[]{new AnalysisInstanceAddSelectionListener(this.table, this.analysisManager), new AnalysisInstanceRemoveArchitectureSelectionListener(this.analysisManager, this.table)};
        section.setClient((Control)this.factory.createHorizontalButtonsForEclipseForm(this.display, (Composite)section, new String[]{"Add", "Remove"}, listenerArray, 128, 8, false));
        return section;
    }

    private void createNavigationButton() {
        Group group = this.factory.createGroupWithWhiteBackgroundTableWrap(this.display, this.comp, "Back to", 2, true, 1, 1);
        this.factory.createHorizontalButtonsForEclipseForm(this.display, (Composite)group, new String[]{"Preparation Page"}, new SelectionAdapter[]{new GoToPreparationPageListener(this.mainEditorUI)}, 4, 4, false);
    }

    private void setWorkComplexityColumnInvisible(Table table) {
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            if (column.getText() == "Work Complexity") {
                column.setWidth(0);
                column.setResizable(false);
            }
            ++n2;
        }
    }

    private void createExportInResultModelButton() {
        Group group = this.factory.createGroupWithWhiteBackgroundTableWrap(this.display, this.comp, "Export to result model", 8, true, 1, 1);
        Button button = new Button((Composite)group, 0);
        button.setText("Go!");
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        button.addSelectionListener((SelectionListener)new ExportToResultmodelListener(this.analysisManager, this.mainEditorUI.getEditingDomain().getResourceSet(), this.mainEditorUI.getMainEditorShell()));
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }
}

