/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.maineditor.page;

import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.kamp.service.maineditor.ICentralEditorPage;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.maineditor.stacklayers.AnalysisInstanceLayer;
import de.fzi.kamp.ui.maineditor.stacklayers.PreparationLayer;
import de.fzi.kamp.ui.maineditor.stacklayers.WorkorganisationTreeLayer;
import de.fzi.kamp.ui.maineditor.stacklayers.WorkplanTableLayer;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class CentralEditorPage
implements ICentralEditorPage {
    private StackLayout stackLayout;
    private ScrolledForm analysisForm;
    private ScrolledForm workplanForm;
    private ScrolledForm preparationForm;
    private ScrolledForm workorganisationForm;
    private PreparationLayer preparationLayer;
    private WorkorganisationTreeLayer workorganisationLayer = new WorkorganisationTreeLayer();
    private AnalysisInstanceLayer analysisInstanceLayer;
    private WorkplanTableLayer workplanLayer = new WorkplanTableLayer(this);
    private SurfaceFactory factory;
    private FormToolkit toolkit;
    private Composite globalContainer;

    public CentralEditorPage() {
        this.preparationLayer = new PreparationLayer();
        this.analysisInstanceLayer = new AnalysisInstanceLayer();
    }

    public Control createAnalysisAndWorkplanForm(AnalysisManager analysisManager, Display display, Composite container, IMainEditor editor) {
        this.factory = new SurfaceFactory();
        this.toolkit = new FormToolkit(display);
        this.globalContainer = new Composite(container, 0);
        this.stackLayout = new StackLayout();
        this.globalContainer.setLayout((Layout)this.stackLayout);
        this.preparationForm = CentralEditorPage.createForm(display, this.globalContainer, this.factory, this.toolkit, "Preparation", 2, false);
        this.preparationLayer.createPreparationPage(analysisManager, editor, this.preparationForm);
        this.analysisForm = CentralEditorPage.createForm(display, this.globalContainer, this.factory, this.toolkit, "Maintainability Analysis Overview", 1, false);
        this.analysisInstanceLayer.createAnalysisInstancePage(analysisManager, display, this.analysisForm, editor);
        this.workplanForm = CentralEditorPage.createForm(display, this.globalContainer, this.factory, this.toolkit, "Workplan Editor", 1, false);
        this.workplanLayer.createWorkplanTable(display, editor, this.workplanForm);
        this.workorganisationForm = CentralEditorPage.createForm(display, this.globalContainer, this.factory, this.toolkit, "Workorganisation", 1, false);
        this.workorganisationLayer.createWorkorganisationTree(analysisManager, display, this.factory, this.workorganisationForm, editor);
        this.stackLayout.topControl = this.preparationForm;
        this.globalContainer.layout();
        return this.globalContainer;
    }

    public TreeViewer getWorkorganisationTreeViewer() {
        return this.workorganisationLayer.getWorkorganisationTreeViewer();
    }

    private static ScrolledForm createForm(Display display, Composite container, SurfaceFactory factory, FormToolkit toolkit, String text, int numColums, boolean makeColumsEqualwidth) {
        ScrolledForm form = toolkit.createScrolledForm(container);
        form.setForeground(new Color((Device)display, 0, 119, 75));
        form.setFont(factory.getFontStyle().get("editorpageheadingStyle"));
        form.setText(text);
        TableWrapLayout layoutForm = new TableWrapLayout();
        layoutForm.topMargin = 10;
        layoutForm.leftMargin = 40;
        layoutForm.rightMargin = 40;
        layoutForm.numColumns = numColums;
        layoutForm.makeColumnsEqualWidth = makeColumsEqualwidth;
        form.getBody().setLayout((Layout)layoutForm);
        return form;
    }

    protected TableWrapData configureTableWrapData(int align, boolean grabHorizontal, int colspan, boolean grabVertical, int valign) {
        TableWrapData twd = new TableWrapData();
        twd.align = align;
        twd.grabHorizontal = grabHorizontal;
        twd.colspan = colspan;
        twd.grabVertical = grabVertical;
        twd.valign = valign;
        return twd;
    }

    public void setPreparationPageAsTopControl() {
        this.stackLayout.topControl = this.preparationForm;
        this.globalContainer.layout();
    }

    public void setWorkplanAsTopControl() {
        this.stackLayout.topControl = this.workplanForm;
        this.globalContainer.layout();
    }

    public void setAnalysisPageAsTopControl() {
        this.stackLayout.topControl = this.analysisForm;
        this.analysisInstanceLayer.getTableViewer().refresh();
        this.globalContainer.layout();
    }

    public void setWorkorganisationPageAsTopControl() {
        this.stackLayout.topControl = this.workorganisationForm;
        this.globalContainer.layout();
    }

    public void setViewForOpenedWorkplan(Workplan workplan, boolean followUp, boolean isEditableEffort, boolean lowestAbstraction) {
        this.workplanLayer.setIsEditableEffort(isEditableEffort);
        this.workplanLayer.showEffortEstimationColumns();
        this.workplanForm.reflow(true);
        this.updateWorkplanTree(workplan, followUp, isEditableEffort, lowestAbstraction);
    }

    public void showDeveloperStructure(boolean showDeveloper) {
        this.workplanLayer.showDeveloperOrLowestAbstactionStructureView(showDeveloper);
    }

    public void updateWorkplanTree(Workplan workplan, boolean followUp, boolean isEditableEffort, boolean lowestAbstraction) {
        this.workplanLayer.getAdapter().update(workplan, followUp, isEditableEffort, lowestAbstraction);
    }

    public void setAddCompositeActivityButtonVisible() {
        this.workplanLayer.setAddCompositeTaskButtonVisible();
    }

    public WorkplanTableLayer getWorkplanLayer() {
        return this.workplanLayer;
    }
}

