/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.analysisoverview.providers;

import de.fzi.kamp.ui.analysisoverview.providers.AnalysisInstanceSummaryType;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.workplan.Task;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SummaryTableContentProvider
implements IStructuredContentProvider {
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof MaintainabilityAnalysisModel) {
            return this.getSummaryAsTableViewerInput((List<?>)((MaintainabilityAnalysisModel)inputElement).getAnalysisinstances()).toArray();
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private List<AnalysisInstanceSummaryType> getSummaryAsTableViewerInput(List<?> list) {
        ArrayList<AnalysisInstanceSummaryType> usedAlternatives = new ArrayList<AnalysisInstanceSummaryType>();
        for (Object nextElement : list) {
            if (!(nextElement instanceof EffortAnalysisInstance)) continue;
            EffortAnalysisInstance instance = (EffortAnalysisInstance)nextElement;
            AnalysisInstanceSummaryType archiAlt = this.getArchitectureAlternativeFromListIfAvailable(instance, usedAlternatives);
            if (archiAlt != null) {
                if (instance.getWorkplan() == null) continue;
                archiAlt.addEffort(((Task)instance.getWorkplan().getTasks().get(0)).getAggregatedTimeEstimate());
                continue;
            }
            AnalysisInstanceSummaryType newTypeForSummary = new AnalysisInstanceSummaryType(instance);
            usedAlternatives.add(newTypeForSummary);
        }
        return usedAlternatives;
    }

    private AnalysisInstanceSummaryType getArchitectureAlternativeFromListIfAvailable(EffortAnalysisInstance instance, List<AnalysisInstanceSummaryType> usedAlternatives) {
        for (AnalysisInstanceSummaryType type : usedAlternatives) {
            if (!type.getArchitectureAlternative().equals(instance.getArchitecturalalternative())) continue;
            return type;
        }
        return null;
    }
}

