/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.analysisoverview.dialog;

import de.fzi.kamp.service.analysisinstance.AnalysisAlternativeAndChangeRequestTuple;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AddAnalysisInstanceAndhangeRequestDialog
extends Dialog {
    private MaintainabilityAnalysisModel analysisModel;
    private Combo comboAlternatives;
    private Combo comboChangeRequests;
    private AnalysisAlternativeAndChangeRequestTuple result;

    public AddAnalysisInstanceAndhangeRequestDialog(Shell parentShell, MaintainabilityAnalysisModel analysisModel, AnalysisAlternativeAndChangeRequestTuple result) {
        super(parentShell);
        this.analysisModel = analysisModel;
        this.result = result;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Choose Analysis Instance");
        Rectangle rec = shell.getDisplay().getBounds();
        int shellWidth = 320;
        int shellHeight = 200;
        int indentionLeft = (rec.width - shellWidth) / 2;
        int indentionTop = (rec.height - shellHeight) / 2;
        shell.setBounds(indentionLeft, indentionTop, shellWidth, shellHeight);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        Composite area = (Composite)this.getDialogArea();
        this.setLayout(area);
        this.createLabel(area, "Architecture Alternative:");
        this.comboAlternatives = new Combo(area, 8);
        this.setLayoutData(this.comboAlternatives);
        for (ArchitecturalAlternative alternative : this.analysisModel.getArchitecturealternatives()) {
            this.comboAlternatives.add(alternative.getName());
        }
        this.createLabel(area, "Change Request:");
        this.comboChangeRequests = new Combo(area, 8);
        this.setLayoutData(this.comboChangeRequests);
        for (ChangeRequest changeRequest : this.analysisModel.getChangerequests()) {
            this.comboChangeRequests.add(changeRequest.getName());
        }
        return control;
    }

    protected void okPressed() {
        int selectionIndexAA = this.comboAlternatives.getSelectionIndex();
        this.result.architectureAlternative = (ArchitecturalAlternative)this.analysisModel.getArchitecturealternatives().get(selectionIndexAA);
        int selectionIndexCR = this.comboChangeRequests.getSelectionIndex();
        this.result.changeRequest = (ChangeRequest)this.analysisModel.getChangerequests().get(selectionIndexCR);
        super.okPressed();
    }

    private void createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
    }

    private void setLayout(Composite comp) {
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        comp.setLayout((Layout)gl);
    }

    private void setLayoutData(Combo combo) {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        combo.setLayoutData((Object)gd);
    }
}

