/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.analysisoverview.adapters;

import de.fzi.kamp.service.analysisinstance.IAnalysisInstanceManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class AnalysisInstanceContentAdapter
extends EContentAdapter {
    private Table table;
    private List<TableEditor> tableEditorList;
    private IAnalysisInstanceManager manager;
    private TableViewer tableViewer;
    private SurfaceFactory surfaceFactory;
    private IMainEditor editor;

    public AnalysisInstanceContentAdapter(Table table, TableViewer tableViewer, IAnalysisInstanceManager manager, IMainEditor editor) {
        this.table = table;
        this.editor = editor;
        this.manager = manager;
        this.tableViewer = tableViewer;
        this.tableEditorList = new LinkedList<TableEditor>();
        this.surfaceFactory = new SurfaceFactory();
        this.update();
    }

    public void notifyChanged(Notification notification) {
        if (notification.getFeatureID(MaintainabilityAnalysisModel.class) == 5 || notification.getFeatureID(MaintainabilityAnalysisModel.class) == 6) {
            this.update();
        }
        super.notifyChanged(notification);
    }

    private void update() {
        this.disposeTableEditors();
        this.tableViewer.refresh();
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            this.tableEditorList = this.surfaceFactory.addButtonsToOverviewTable(item, this.manager, this, this.editor);
            ++n2;
        }
        tableItemArray = this.table.getColumns();
        n = tableItemArray.length;
        n2 = 0;
        while (n2 < n) {
            TableItem c = tableItemArray[n2];
            c.pack();
            if (c.getText().equals("Result Summary")) {
                c.setWidth(130);
            }
            ++n2;
        }
    }

    private void disposeTableEditors() {
        for (TableEditor tableEditor : this.tableEditorList) {
            if (tableEditor.getEditor() != null) {
                tableEditor.getEditor().dispose();
            }
            if (tableEditor.getItem() != null) {
                tableEditor.getItem().dispose();
            }
            tableEditor.dispose();
        }
    }

    public List<TableEditor> getTableEditorList() {
        return this.tableEditorList;
    }
}

