/*
 * Decompiled with CFR 0.152.
 */
package org.somox.core.impl;

import eu.qimpress.qimpressgast.GASTBehaviourRepository;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.ModelAnalyzer;
import org.somox.analyzer.ModelAnalyzerException;
import org.somox.configuration.ConfigurationDefinition;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.core.SoMoXCore;
import org.somox.extractor.ExtractionResult;
import org.somox.extractor.SoftwareExtractor;

public class SoMoXCoreStandard
implements SoMoXCore {
    private static final String PATH_INTERNAL_ARCHITECTUREMODEL = "/internal_architecture_model.samm_repository";
    private static final String PATH_GAST_BEHAVIOUR_REPOSITORY = "/internal_architecture_model.samm_gastbehaviour";
    private static final String PATH_SOURCECODE_DECORATOR_REPOSITORY = "/internal_architecture_model.sourcecodedecorator";
    private HashMap<String, SoftwareExtractor> softwareExtractorMap = new HashMap();
    private HashMap<String, ModelAnalyzer> modelAnalyzerMap = new HashMap();
    private HashMap<String, ExtractionResult> extractionResultMap = new HashMap();
    private List<SoftwareExtractor> executedList = new LinkedList<SoftwareExtractor>();
    private ResourceSet resourceSet = null;
    private Logger logger = Logger.getLogger((String)SoMoXCoreStandard.class.getName());

    public SoMoXCoreStandard() {
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
    }

    @Override
    public void runExtraction(IProgressMonitor progressMonitor, HashMap<String, String> preferences) {
        this.logger.info((Object)"extraction started");
        for (Map.Entry<String, SoftwareExtractor> entry : this.softwareExtractorMap.entrySet()) {
            ExtractionResult result = entry.getValue().runExtraction(entry.getKey(), preferences);
            this.extractionResultMap.put(entry.getKey(), result);
            this.executedList.add(entry.getValue());
        }
        this.logger.info((Object)"extraction finished");
    }

    @Override
    public void runAnalyzer(String analyzerID, IProgressMonitor progressMonitor, HashMap<String, String> preferences, SoMoXConfiguration somoxConfiguration) throws ModelAnalyzerException {
        this.logger.info((Object)"analysis started");
        this.logger.info((Object)("analysis of results: " + this.extractionResultMap));
        String projectIdentifier = somoxConfiguration.getFileLocations().getProjectName();
        String outputFolder = somoxConfiguration.getFileLocations().getOutputFolder();
        Repository internalArchitectureModel = null;
        try {
            internalArchitectureModel = this.getInternalArchitectureModel(projectIdentifier, outputFolder);
        }
        catch (IOException e) {
            this.logger.error((Object)("Model Resource load failed for Analyzer. Location was: " + projectIdentifier), (Throwable)e);
            throw new ModelAnalyzerException("Model Resource load failed for Analyzer.", e);
        }
        this.logger.info((Object)("Start model analyzer (" + analyzerID + ")"));
        ModelAnalyzer analyzer = this.modelAnalyzerMap.get(analyzerID);
        if (analyzer == null) {
            this.logger.error((Object)("Model Analyzer " + analyzerID + " not available."), null);
            throw new ModelAnalyzerException("Model Analyzer not available");
        }
        AnalysisResult result = analyzer.analyze(somoxConfiguration, internalArchitectureModel, this.extractionResultMap, progressMonitor);
        this.logger.info((Object)("Analysis finished with result: " + (Object)((Object)result.getResultStatus())));
        try {
            this.saveInternalArchitectureModel(result.getInternalArchitectureModel(), projectIdentifier, outputFolder);
            this.saveGastBehaviourRepository(result.getGastBehaviourRepository(), projectIdentifier, outputFolder);
            this.saveSourceCodeDecoratorRepository(result.getSourceCodeDecoratorRepository(), projectIdentifier, outputFolder);
        }
        catch (IOException e) {
            this.logger.error((Object)"Model Analyzer failed.", (Throwable)e);
            throw new ModelAnalyzerException("Model Analyzer failed with IOException", e);
        }
    }

    private Repository getInternalArchitectureModel(String projectIdentifier, String outputFolder) throws IOException {
        Repository result = null;
        Resource resource = this.getResource(projectIdentifier, String.valueOf(outputFolder) + PATH_INTERNAL_ARCHITECTUREMODEL, (EObject)StaticstructureFactory.eINSTANCE.createRepository());
        if (resource.getContents().size() == 0) {
            this.logger.error((Object)"The internal architecture model file does not contain a model.", (Throwable)new Exception("No internal architecture model repository available."));
        } else {
            EObject content = (EObject)resource.getContents().get(0);
            if (content instanceof Repository) {
                result = (Repository)content;
            } else {
                this.logger.error((Object)"The internal architecture model resource contains a model of a wrong type.", (Throwable)new Exception("Wrong emf model type in resource " + content));
            }
        }
        return result;
    }

    private void saveInternalArchitectureModel(Repository internalArchitectureModel, String projectIdentifier, String outputFolder) throws IOException {
        this.save((EObject)internalArchitectureModel, projectIdentifier, String.valueOf(outputFolder) + PATH_INTERNAL_ARCHITECTUREMODEL);
    }

    private void saveGastBehaviourRepository(GASTBehaviourRepository repository, String projectIdentifier, String outputFolder) throws IOException {
        this.save((EObject)repository, projectIdentifier, String.valueOf(outputFolder) + PATH_GAST_BEHAVIOUR_REPOSITORY);
    }

    private void saveSourceCodeDecoratorRepository(SourceCodeDecoratorRepository repository, String projectIdentifier, String outputFolder) throws IOException {
        this.save((EObject)repository, projectIdentifier, String.valueOf(outputFolder) + PATH_SOURCECODE_DECORATOR_REPOSITORY);
    }

    private void save(EObject emfObject, String projectIdentifier, String path) throws IOException {
        ResourceSet resourceSet = this.getResourceSetForURI();
        URI uri = URI.createURI((String)("platform:/resource/" + projectIdentifier + path));
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().add((Object)emfObject);
        resource.save(Collections.EMPTY_MAP);
    }

    private ResourceSet getResourceSetForURI() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        return resourceSet;
    }

    private Resource getResource(String projectIdentifier, String path, EObject defaultObject) throws IOException {
        URI uri = URI.createURI((String)("platform:/resource/" + projectIdentifier + path));
        Resource resource = this.resourceSet.getResource(uri, false);
        if (resource == null || resource.getContents().isEmpty()) {
            resource = this.resourceSet.createResource(uri);
            resource.getContents().add((Object)defaultObject);
            resource.save(null);
        }
        return resource;
    }

    @Override
    public void runExport(IProgressMonitor progressMonitor) {
    }

    @Override
    public void addSoftwareExtractor(String id, SoftwareExtractor extractor) {
        this.softwareExtractorMap.put(id, extractor);
    }

    @Override
    public void removeSoftwareExtractor(String id) {
        this.softwareExtractorMap.remove(id);
    }

    @Override
    public void addModelAnalyzer(String id, ModelAnalyzer analyzer) {
        this.modelAnalyzerMap.put(id, analyzer);
    }

    @Override
    public void removeModelAnalyzer(String id) {
        this.modelAnalyzerMap.remove(id);
    }

    @Override
    public List<SoftwareExtractor> getExecutedSoftwareExtractors() {
        return this.executedList;
    }

    @Override
    public LinkedList<ConfigurationDefinition> getConfigurationDefinitions() {
        LinkedList<ConfigurationDefinition> definitions = new LinkedList<ConfigurationDefinition>();
        definitions.addAll(this.getCoreConfigurationDefinitions());
        Iterator<SoftwareExtractor> extractors = this.softwareExtractorMap.values().iterator();
        while (extractors.hasNext()) {
            definitions.addAll(extractors.next().getConfigurationDefinitions());
        }
        return definitions;
    }

    @Override
    public LinkedList<ConfigurationDefinition> getGlobalConfigurationDefinitions() {
        LinkedList<ConfigurationDefinition> definitions = new LinkedList<ConfigurationDefinition>();
        return definitions;
    }

    private Collection<ConfigurationDefinition> getCoreConfigurationDefinitions() {
        LinkedList<ConfigurationDefinition> configs = new LinkedList<ConfigurationDefinition>();
        return configs;
    }
}

