/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer;

import de.fzi.gast.accesses.provider.accessesItemProviderAdapterFactory;
import de.fzi.gast.annotations.provider.annotationsItemProviderAdapterFactory;
import de.fzi.gast.core.Root;
import de.fzi.gast.core.provider.coreItemProviderAdapterFactory;
import de.fzi.gast.functions.provider.functionsItemProviderAdapterFactory;
import de.fzi.gast.helpers.GASTReader;
import de.fzi.gast.statements.provider.statementsItemProviderAdapterFactory;
import de.fzi.gast.types.provider.typesItemProviderAdapterFactory;
import de.fzi.gast.variables.provider.variablesItemProviderAdapterFactory;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Level;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.somox.analyzer.BlackboardListener;
import org.somox.core.Activator;

public class ModelAnalyzerTabGroupBlackboard {
    private Root root;
    private ComposedAdapterFactory adapterFactory;
    static int idCounter = 0;
    private int myId = 0;
    private ILog logger = Activator.getPlugin().getLog();
    private String somoxAnalyzerInputFile = null;
    private Level debugLvl = Level.INFO;
    private transient Vector<BlackboardListener> blackboardListeners;

    public ModelAnalyzerTabGroupBlackboard() {
        this.myId = ++idCounter;
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new statementsItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new coreItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new annotationsItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new typesItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new functionsItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new accessesItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new variablesItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
    }

    public int getId() {
        return this.myId;
    }

    public Level getDebugLvl() {
        return this.debugLvl;
    }

    public void setDebugLvl(int debugLvl) {
        switch (debugLvl) {
            case 0: {
                this.debugLvl = Level.INFO;
                break;
            }
            case 1: {
                this.debugLvl = Level.DEBUG;
                break;
            }
            default: {
                this.debugLvl = Level.ALL;
            }
        }
    }

    public String getSomoxAnalyzerInputFile() {
        return this.somoxAnalyzerInputFile;
    }

    public void setSomoxAnalyzerInputFile(String somoxAnalyzerInputFile) {
        if (this.somoxAnalyzerInputFile == null) {
            this.somoxAnalyzerInputFile = somoxAnalyzerInputFile;
            if (this.somoxAnalyzerInputFile != null) {
                if (somoxAnalyzerInputFile.endsWith(".gast")) {
                    this.loadModel();
                } else {
                    this.root = null;
                }
            } else {
                this.root = null;
            }
            this.fireBlackboardChanged();
        } else if (this.somoxAnalyzerInputFile != null && !this.somoxAnalyzerInputFile.equals(somoxAnalyzerInputFile)) {
            this.somoxAnalyzerInputFile = somoxAnalyzerInputFile;
            if (this.somoxAnalyzerInputFile != null) {
                if (somoxAnalyzerInputFile.endsWith(".gast")) {
                    this.loadModel();
                } else {
                    this.root = null;
                }
            } else {
                this.root = null;
            }
            this.fireBlackboardChanged();
        }
    }

    private void loadModel() {
        URI fileURI = URI.createPlatformResourceURI((String)this.somoxAnalyzerInputFile, (boolean)true);
        Resource resource = null;
        try {
            GASTReader gastReader = new GASTReader();
            gastReader.loadFile(fileURI);
            resource = gastReader.getResourceGAST();
        }
        catch (IOException e1) {
            this.logger.log((IStatus)new Status(4, "org.somox.core", "Failed to load Model file " + fileURI));
            e1.printStackTrace();
        }
        EList contents = resource.getContents();
        for (EObject current : contents) {
            if (!(current instanceof Root)) continue;
            this.root = (Root)current;
            break;
        }
    }

    public Root getRoot() {
        return this.root;
    }

    public synchronized void addBlackboardListener(BlackboardListener listener) {
        if (this.blackboardListeners == null) {
            this.blackboardListeners = new Vector();
        }
        this.blackboardListeners.addElement(listener);
    }

    public synchronized void removeBlackboardListener(BlackboardListener listener) {
        if (this.blackboardListeners == null) {
            this.blackboardListeners = new Vector();
        }
        this.blackboardListeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireBlackboardChanged() {
        if (this.blackboardListeners != null && !this.blackboardListeners.isEmpty()) {
            Vector targets;
            Vector<BlackboardListener> vector = this.blackboardListeners;
            synchronized (vector) {
                targets = (Vector)this.blackboardListeners.clone();
            }
            Enumeration e = targets.elements();
            while (e.hasMoreElements()) {
                BlackboardListener l = (BlackboardListener)e.nextElement();
                l.blackboardChanged();
            }
        }
    }
}

