/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.detection;

import de.fzi.gast.core.Root;
import de.fzi.gast.types.GASTClass;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.graph.DirectedSubgraph;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.graph.Subgraph;
import org.somox.analyzer.ModelAnalyzerException;
import org.somox.analyzer.simplemodelanalyzer.builder.ComponentBuilder;
import org.somox.analyzer.simplemodelanalyzer.detection.IDetectionStrategy;
import org.somox.analyzer.simplemodelanalyzer.detection.NodePair;
import org.somox.analyzer.simplemodelanalyzer.detection.util.ComponentPrinter;
import org.somox.analyzer.simplemodelanalyzer.detection.util.EdgeThresholdFilter;
import org.somox.analyzer.simplemodelanalyzer.metrics.DefaultCompositionIndicatingMetric;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.filter.BaseFilter;
import org.somox.filter.FilteredCollectionsFactory;
import org.somox.metrics.ClusteringRelation;
import org.somox.metrics.IMetric;
import org.somox.metrics.MetricID;
import org.somox.metrics.MetricsRegistry;
import org.somox.metrics.helper.Class2ClassAccessGraphHelper;
import org.somox.metrics.helper.ClassAccessGraphEdge;
import org.somox.metrics.helper.ComponentToImplementingClassesHelper;
import org.somox.metrics.util.GraphPrinter;

public class ComponentDetectionByClustering
implements IDetectionStrategy {
    private static Logger logger = Logger.getLogger(ComponentDetectionByClustering.class);
    private final Root gastModel;
    private final SoMoXConfiguration somoxConfiguration;
    private ComponentToImplementingClassesHelper componentToImplementingClassHelper = new ComponentToImplementingClassesHelper();
    private final IMetric compositionIndicatingMetric;
    private final Map<MetricID, IMetric> allMetrics;
    private ExecutorCompletionService<ClusteringRelation[]> completionService;

    public ComponentDetectionByClustering(Root gastModelToAnalyze, List<ComponentImplementingClassesLink> componentCandidates, SoMoXConfiguration somoxConfig) {
        GraphPrinter.cleanOutputFolder((String)somoxConfig.getFileLocations().getAnalyserInputFile());
        this.gastModel = gastModelToAnalyze;
        this.somoxConfiguration = somoxConfig;
        this.allMetrics = this.initializeMetrics(componentCandidates);
        this.compositionIndicatingMetric = this.getMetric(this.allMetrics, DefaultCompositionIndicatingMetric.METRIC_ID);
    }

    @Override
    public List<ComponentImplementingClassesLink> startDetection(ComponentBuilder sammBuilder, SoMoXConfiguration somoxConfig, IProgressMonitor progressMonitor, List<ComponentImplementingClassesLink> componentCandidates) throws ModelAnalyzerException {
        double currentThreshold = this.somoxConfiguration.getClusteringConfig().getMaxClusteringThreshold();
        double minThreshold = this.somoxConfiguration.getClusteringConfig().getMinClusteringThreshold();
        int componentCount = componentCandidates.size();
        boolean newComponentsFound = true;
        int iteration = 0;
        DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> compositionIndicatingGraph = this.setupGraph(componentCandidates);
        ExecutorService pool = Executors.newFixedThreadPool(5);
        this.completionService = new ExecutorCompletionService(pool);
        while (currentThreshold >= minThreshold && componentCandidates.size() > 1) {
            DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> projectedGraph;
            logger.info((Object)("Clustering iteration nr.: " + ++iteration));
            logger.info((Object)("NR Components: " + componentCandidates.size()));
            if (newComponentsFound) {
                compositionIndicatingGraph = this.computeAllMetrics(componentCandidates, this.compositionIndicatingMetric, somoxConfig.getClusteringConfig().getMinClusteringThreshold(), compositionIndicatingGraph, progressMonitor);
            }
            if ((projectedGraph = this.projectGraph(compositionIndicatingGraph, this.compositionIndicatingMetric, currentThreshold)).edgeSet().size() > 0) {
                GraphPrinter.dumpGraph((ComponentToImplementingClassesHelper)this.componentToImplementingClassHelper, projectedGraph, (String)this.somoxConfiguration.getFileLocations().getAnalyserInputFile(), (int)iteration, (int)0);
            }
            if ((componentCandidates = this.componentComposition(sammBuilder, projectedGraph, iteration)).size() == componentCount) {
                newComponentsFound = false;
            } else {
                componentCount = componentCandidates.size();
                newComponentsFound = true;
            }
            if (newComponentsFound) continue;
            currentThreshold -= this.somoxConfiguration.getClusteringConfig().getClusteringThresholdDecrement();
        }
        if (logger.isDebugEnabled()) {
            ComponentPrinter.printComponents(componentCandidates, logger);
        }
        pool.shutdown();
        return componentCandidates;
    }

    private DirectedGraph<GASTClass, ClassAccessGraphEdge> getAccessGraph(List<ComponentImplementingClassesLink> componentCandidates) {
        DirectedGraph accessGraph = Class2ClassAccessGraphHelper.computeFilteredClass2ClassAccessGraph((SoMoXConfiguration)this.somoxConfiguration, (Set)this.componentToImplementingClassHelper.collectAllClasses(componentCandidates));
        return accessGraph;
    }

    private Map<MetricID, IMetric> initializeMetrics(List<ComponentImplementingClassesLink> componentCandidates) {
        Map allMetrics = MetricsRegistry.getRegisteredMetrics();
        DirectedGraph<GASTClass, ClassAccessGraphEdge> accessGraph = this.getAccessGraph(componentCandidates);
        for (IMetric metric : allMetrics.values()) {
            metric.initialize(this.gastModel, this.somoxConfiguration, allMetrics, accessGraph, this.componentToImplementingClassHelper);
        }
        return allMetrics;
    }

    private DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> projectGraph(DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> compositionIndicatingGraph, IMetric metric, double threshold) {
        EdgeThresholdFilter filter = new EdgeThresholdFilter(metric.getMID(), threshold);
        return new DirectedSubgraph(compositionIndicatingGraph, compositionIndicatingGraph.vertexSet(), FilteredCollectionsFactory.getFilteredHashSet((BaseFilter)filter, (Iterable)compositionIndicatingGraph.edgeSet()));
    }

    private DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> computeAllMetrics(List<ComponentImplementingClassesLink> componentCandidates, IMetric metricComputationStrategy, double threshold, DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> previousGraph, IProgressMonitor progressMonitor) throws ModelAnalyzerException {
        Collection<NodePair> work = this.deriveComputationWork(componentCandidates, previousGraph);
        int totalCount = work.size();
        SubProgressMonitor clusteringProgressMonitor = new SubProgressMonitor(progressMonitor, totalCount);
        long startTimeClustering = System.nanoTime();
        logger.debug((Object)("Creating weighted directed graph for " + componentCandidates.size() + " components."));
        for (NodePair nodePair : work) {
            this.completionService.submit(nodePair.getWorkTask(this.compositionIndicatingMetric, this.allMetrics));
        }
        try {
            int stepNo = 0;
            while (stepNo < totalCount) {
                ClusteringRelation[] computedRelationPair;
                ClusteringRelation[] clusteringRelationArray = computedRelationPair = this.completionService.take().get();
                int n = computedRelationPair.length;
                int n2 = 0;
                while (n2 < n) {
                    ClusteringRelation relation = clusteringRelationArray[n2];
                    this.addEdgeToGraph((Graph<ComponentImplementingClassesLink, ClusteringRelation>)previousGraph, relation);
                    ++n2;
                }
                logger.debug((Object)(String.valueOf(stepNo * 100 / totalCount) + "% of clustering done."));
                ++stepNo;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Parallel execution failed unexpectedly", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Parallel execution failed unexpectedly", e);
        }
        long clusteringTime = System.nanoTime() - startTimeClustering;
        logger.debug((Object)("TIME for Compute All Metrics: " + TimeUnit.NANOSECONDS.toSeconds(clusteringTime) + " s"));
        clusteringProgressMonitor.done();
        return previousGraph;
    }

    private Collection<NodePair> deriveComputationWork(List<ComponentImplementingClassesLink> componentCandidates, DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> previousGraph) {
        HashSet<ComponentImplementingClassesLink> newNodes = new HashSet<ComponentImplementingClassesLink>();
        HashSet<ComponentImplementingClassesLink> nodesToRemove = new HashSet<ComponentImplementingClassesLink>();
        for (ComponentImplementingClassesLink link : previousGraph.vertexSet()) {
            if (componentCandidates.contains(link)) continue;
            nodesToRemove.add(link);
        }
        previousGraph.removeAllVertices(nodesToRemove);
        HashSet<ComponentImplementingClassesLink> oldNodesSet = new HashSet<ComponentImplementingClassesLink>(previousGraph.vertexSet());
        for (ComponentImplementingClassesLink link : componentCandidates) {
            if (previousGraph.vertexSet().contains(link)) continue;
            newNodes.add(link);
            previousGraph.addVertex((Object)link);
        }
        assert (Collections.disjoint(newNodes, oldNodesSet));
        int totalCount = newNodes.size() * (newNodes.size() - 1) / 2 + newNodes.size() * oldNodesSet.size();
        Collection<NodePair> pairsToCompute = this.derivePairsToCompute(newNodes, oldNodesSet);
        assert (pairsToCompute.size() == totalCount);
        return pairsToCompute;
    }

    private Collection<NodePair> derivePairsToCompute(Set<ComponentImplementingClassesLink> newNodes, Set<ComponentImplementingClassesLink> oldNodesSet) {
        HashSet<NodePair> result = new HashSet<NodePair>();
        for (ComponentImplementingClassesLink oldNode : oldNodesSet) {
            for (ComponentImplementingClassesLink newNode : newNodes) {
                result.add(new NodePair(newNode, oldNode));
            }
        }
        for (ComponentImplementingClassesLink newNode1 : newNodes) {
            for (ComponentImplementingClassesLink newNode2 : newNodes) {
                NodePair newPair;
                if (newNode1 == newNode2 || result.contains(newPair = new NodePair(newNode1, newNode2))) continue;
                result.add(newPair);
            }
        }
        return result;
    }

    private DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> setupGraph(List<ComponentImplementingClassesLink> componentCandidates) {
        SimpleDirectedGraph result = new SimpleDirectedGraph(ClusteringRelation.class);
        return result;
    }

    private void addEdgeToGraph(Graph<ComponentImplementingClassesLink, ClusteringRelation> result, ClusteringRelation relation) {
        if ((Double)relation.getResult().get(this.compositionIndicatingMetric.getMID()) > this.somoxConfiguration.getClusteringConfig().getMinClusteringThreshold()) {
            logger.debug((Object)(String.valueOf(relation.getComponentA().getComponent().getName()) + " --" + relation.getResult().get(this.compositionIndicatingMetric.getMID()) + "--> " + relation.getComponentB().getComponent().getName()));
            result.addEdge((Object)relation.getComponentA(), (Object)relation.getComponentB(), (Object)relation);
        }
    }

    private List<ComponentImplementingClassesLink> componentComposition(ComponentBuilder sammBuilder, DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> relationshipGraph, int iteration) {
        LinkedList<ComponentImplementingClassesLink> result = new LinkedList<ComponentImplementingClassesLink>();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)relationshipGraph.toString());
        }
        ConnectivityInspector connectivityInspector = new ConnectivityInspector(relationshipGraph);
        List subGraphs = connectivityInspector.connectedSets();
        logger.debug((Object)("Found " + subGraphs.size() + " strong components in relation graph."));
        int subgraphNo = 1;
        for (Set componentsToMerge : subGraphs) {
            if (componentsToMerge.size() > 1) {
                logger.debug((Object)("Found a cluster of " + componentsToMerge.size() + " related components. Merging them into a composite component"));
                Subgraph compositeComponentSubgraph = new Subgraph(relationshipGraph, componentsToMerge);
                if (compositeComponentSubgraph.edgeSet().size() > 0) {
                    GraphPrinter.dumpGraph((ComponentToImplementingClassesHelper)this.componentToImplementingClassHelper, (Graph)compositeComponentSubgraph, (String)this.somoxConfiguration.getFileLocations().getAnalyserInputFile(), (int)iteration, (int)subgraphNo++);
                }
                ComponentImplementingClassesLink newComponent = sammBuilder.createCompositeComponent((Graph<ComponentImplementingClassesLink, ClusteringRelation>)compositeComponentSubgraph);
                result.add(newComponent);
                continue;
            }
            result.addAll(componentsToMerge);
        }
        return result;
    }

    private IMetric getMetric(Map<MetricID, IMetric> allMetrics, MetricID metricId) {
        IMetric result = allMetrics.get(metricId);
        if (result == null) {
            throw new RuntimeException("Configuration error, Metric " + metricId + " needed but not available");
        }
        return result;
    }
}

