/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.detection;

import de.fzi.gast.core.Root;
import de.fzi.gast.functions.Method;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.GASTStruct;
import de.fzi.gast.types.typesPackage;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.somox.analyzer.simplemodelanalyzer.builder.ComponentBuilder;
import org.somox.analyzer.simplemodelanalyzer.detection.IInitializationStrategy;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.filter.BaseFilter;
import org.somox.filter.ComposedFilter;
import org.somox.filter.DataObjectFilter;
import org.somox.filter.EClassBasedFilter;

public class BasicInitializationStrategy
implements IInitializationStrategy {
    private static final BaseFilter<GASTClass> primitiveClassesFilter = new BaseFilter<GASTClass>(){

        public boolean passes(GASTClass object) {
            return !object.isPrimitive();
        }
    };
    private static final BaseFilter<GASTClass> unknownClassTypeFilter = new BaseFilter<GASTClass>(){

        public boolean passes(GASTClass object) {
            return !object.getSimpleName().equals("<unknownClassType>");
        }
    };
    private static final BaseFilter<GASTClass> improperStructFilter = new BaseFilter<GASTClass>(){

        public boolean passes(GASTClass object) {
            return !(object instanceof GASTStruct) || !this.hasVirtualMethod(object);
        }

        private boolean hasVirtualMethod(GASTClass clazz) {
            boolean hasVirtualMethod = false;
            for (Method method : clazz.getMethods()) {
                if (!method.isVirtual()) continue;
                hasVirtualMethod = true;
                break;
            }
            return hasVirtualMethod;
        }
    };
    private static final BaseFilter<GASTClass> dataObjectFilter = new DataObjectFilter();

    @Override
    public List<ComponentImplementingClassesLink> createInitialComponentCandidates(Root root, SoMoXConfiguration config, ComponentBuilder builder) {
        ArrayList<ComponentImplementingClassesLink> result = new ArrayList<ComponentImplementingClassesLink>();
        EList classList = root.getAllNormalClasses();
        ComposedFilter gastClassFilter = new ComposedFilter(new BaseFilter[]{config.getBlacklistFilter(), new EClassBasedFilter(new EClass[]{typesPackage.eINSTANCE.getGASTEnumeration(), typesPackage.eINSTANCE.getGASTUnion()}), primitiveClassesFilter, improperStructFilter, dataObjectFilter, unknownClassTypeFilter});
        for (GASTClass clazz : gastClassFilter.filter((Iterable)classList)) {
            ComponentImplementingClassesLink newPrimitiveComponent = builder.createPrimitiveComponentFromGASTClass(clazz);
            result.add(newPrimitiveComponent);
        }
        return result;
    }
}

