/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import de.fzi.gast.core.Root;
import de.fzi.gast.functions.Function;
import de.fzi.gast.functions.Method;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.Visibilities;
import de.fzi.gast.variables.FormalParameter;
import eu.qimpress.samm.datatypes.CollectionDataType;
import eu.qimpress.samm.datatypes.DatatypesFactory;
import eu.qimpress.samm.datatypes.PrimitiveDataType;
import eu.qimpress.samm.datatypes.Type;
import eu.qimpress.samm.datatypes.XSDPrimitiveDataTypes;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.MessageType;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.staticstructure.Parameter;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;
import eu.qimpress.sourcecodedecorator.MethodLevelSourceCodeLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.configuration.SoMoXConfiguration;

public class OperationBuilder
extends AbstractBuilder {
    private static Logger logger = Logger.getLogger(OperationBuilder.class);

    public OperationBuilder(Root gastModel, SoMoXConfiguration somoxConfiguration, AnalysisResult analysisResult) {
        super(gastModel, somoxConfiguration, analysisResult);
    }

    public void createOperations(GASTClass implementationClass, GASTClass interfaceClass, Interface interf) {
        for (Method method : interfaceClass.getMethods()) {
            if (!method.getVisibility().equals((Object)Visibilities.VISIBILITYPACKAGE) && !method.getVisibility().equals((Object)Visibilities.VISIBILITYPUBLIC)) continue;
            Method realMethod = method;
            if (implementationClass != null && (realMethod = this.getRealMethod(implementationClass, method)) == null) {
                realMethod = method;
                logger.error((Object)("GAST Model misses a method " + method.getSimpleName()));
            }
            Operation op = this.createOperationParametersAndMessageType(realMethod);
            interf.getSignatures().add((Object)op);
        }
    }

    private Method getRealMethod(GASTClass implementationClass, Method method) {
        for (Method m : implementationClass.getMethods()) {
            if (m == method) {
                return m;
            }
            if (!m.getSimpleName().equals(method.getSimpleName())) continue;
            Method overrideMethod = (Method)m.getOverriddenMember();
            while (overrideMethod != null) {
                if (overrideMethod == method) {
                    return m;
                }
                overrideMethod = (Method)overrideMethod.getOverriddenMember();
            }
        }
        for (GASTClass superClass : implementationClass.getSuperTypes()) {
            Method real;
            if (superClass.isAbstract() || superClass.isInterface() || (real = this.getRealMethod(superClass, method)) == null) continue;
            return real;
        }
        return null;
    }

    private Operation createOperationParametersAndMessageType(Method method) {
        Operation operation = StaticstructureFactory.eINSTANCE.createOperation();
        operation.setName(method.getSimpleName());
        this.updateSourceCodeDecorator(operation, method);
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<String> paramTypes = new ArrayList<String>();
        for (FormalParameter inputParameter : method.getFormalParameters()) {
            paramNames.add(inputParameter.getSimpleName());
            if (inputParameter.getType() != null) {
                paramTypes.add(inputParameter.getType().getSimpleName());
                continue;
            }
            logger.error((Object)("Input parameter type was null. Could not set the parameter type \"" + inputParameter.getSimpleName() + "\" of method \"" + method.getSimpleName() + "\""));
        }
        if (paramNames.size() > 0) {
            MessageType messageType = this.findMessageTypeInRepository(paramNames, paramTypes);
            if (messageType == null) {
                messageType = this.createMessageType(paramNames, paramTypes);
            }
            operation.setInput(messageType);
        }
        return operation;
    }

    private void updateSourceCodeDecorator(Operation operation, Method method) {
        MethodLevelSourceCodeLink link = SourceCodeDecoratorFactory.eINSTANCE.createMethodLevelSourceCodeLink();
        link.setFunction((Function)method);
        link.setOperation(operation);
        if (method.getPosition() != null && method.getPosition().getSourceFile() != null) {
            link.setFile(method.getPosition().getSourceFile());
        }
        this.analysisResult.getSourceCodeDecoratorRepository().getMethodLevelSourceCodeLink().add((Object)link);
    }

    private MessageType findMessageTypeInRepository(List<String> parameterNames, List<String> parameterTypes) {
        if (parameterNames == null) {
            parameterNames = new ArrayList<String>();
        }
        if (parameterTypes == null) {
            parameterTypes = new ArrayList<String>();
        }
        if (parameterNames.size() != parameterTypes.size()) {
            return null;
        }
        for (MessageType messageType : this.analysisResult.getInternalArchitectureModel().getMessagetype()) {
            if (messageType.getParameters().size() != parameterNames.size()) continue;
            boolean parametersMatch = true;
            int i = 0;
            while (i < messageType.getParameters().size()) {
                Parameter param = (Parameter)messageType.getParameters().get(i);
                if (!param.getName().equals(parameterNames.get(i))) {
                    parametersMatch = false;
                    break;
                }
                if (!param.getType().getName().toLowerCase().equals(parameterTypes.get(i).toLowerCase())) {
                    parametersMatch = false;
                    break;
                }
                ++i;
            }
            if (!parametersMatch) continue;
            return messageType;
        }
        return null;
    }

    private MessageType createMessageType(List<String> parameterNames, List<String> parameterTypes) {
        if (parameterNames == null) {
            parameterNames = new ArrayList<String>();
        }
        if (parameterTypes == null) {
            parameterTypes = new ArrayList<String>();
        }
        if (parameterNames.size() != parameterTypes.size()) {
            return null;
        }
        MessageType messageType = StaticstructureFactory.eINSTANCE.createMessageType();
        String messageTypeName = "";
        if (parameterTypes.size() > 0) {
            int i = 0;
            while (i < parameterTypes.size()) {
                if (messageTypeName.length() > 0) {
                    messageTypeName = String.valueOf(messageTypeName) + "_";
                }
                messageTypeName = String.valueOf(messageTypeName) + parameterTypes.get(i);
                Parameter param = StaticstructureFactory.eINSTANCE.createParameter();
                param.setName(parameterNames.get(i));
                param.setType(this.getType(parameterTypes.get(i), this.analysisResult.getInternalArchitectureModel()));
                messageType.getParameters().add((Object)param);
                ++i;
            }
        }
        messageType.setName(messageTypeName);
        this.analysisResult.getInternalArchitectureModel().getMessagetype().add((Object)messageType);
        return messageType;
    }

    private Type getType(String typeName, Repository repository) {
        Type type2;
        if (typeName.toLowerCase().equals("int")) {
            typeName = "integer";
        } else if (typeName.toLowerCase().equals("bool")) {
            typeName = "boolean";
        }
        for (Type type2 : repository.getType()) {
            if (!type2.getName().toLowerCase().equals(typeName.toLowerCase())) continue;
            return type2;
        }
        type2 = null;
        if (typeName.toLowerCase().equals("integer")) {
            type2 = DatatypesFactory.eINSTANCE.createPrimitiveDataType();
            type2.setName("INTEGER");
            ((PrimitiveDataType)type2).setType(XSDPrimitiveDataTypes.INT);
        } else if (typeName.toLowerCase().equals("float")) {
            type2 = DatatypesFactory.eINSTANCE.createPrimitiveDataType();
            type2.setName("FLOAT");
            ((PrimitiveDataType)type2).setType(XSDPrimitiveDataTypes.FLOAT);
        } else if (typeName.toLowerCase().equals("string")) {
            type2 = DatatypesFactory.eINSTANCE.createPrimitiveDataType();
            type2.setName("STRING");
            ((PrimitiveDataType)type2).setType(XSDPrimitiveDataTypes.STRING);
        } else if (typeName.toLowerCase().equals("boolean")) {
            type2 = DatatypesFactory.eINSTANCE.createPrimitiveDataType();
            type2.setName("BOOLEAN");
            ((PrimitiveDataType)type2).setType(XSDPrimitiveDataTypes.BOOLEAN);
        } else if (typeName.endsWith("[]")) {
            String tmpTypeName = typeName.substring(0, typeName.length() - 2);
            type2 = DatatypesFactory.eINSTANCE.createCollectionDataType();
            type2.setName(typeName);
            ((CollectionDataType)type2).setInnertype(this.getType(tmpTypeName, repository));
        } else {
            type2 = DatatypesFactory.eINSTANCE.createComplexDataType();
            type2.setName(typeName);
        }
        repository.getType().add((Object)type2);
        return type2;
    }
}

