/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import de.fzi.gast.core.Root;
import eu.qimpress.qimpressgast.GASTBehaviour;
import eu.qimpress.qimpressgast.qimpressgastFactory;
import eu.qimpress.samm.behaviour.BehaviourFactory;
import eu.qimpress.samm.behaviour.GastBehaviourStub;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.sourcecodedecorator.MethodLevelSourceCodeLink;
import org.apache.log4j.Logger;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.configuration.SoMoXConfiguration;

public class GASTBehaviourBuilder
extends AbstractBuilder {
    private static final Logger logger = Logger.getLogger(GASTBehaviourBuilder.class);

    public GASTBehaviourBuilder(Root gastModel, SoMoXConfiguration somoxConfiguration, AnalysisResult analysisResult) {
        super(gastModel, somoxConfiguration, analysisResult);
    }

    public void addGASTBehaviourToPrimitiveComponent(PrimitiveComponent component, InterfacePort providedRole) {
        for (Operation operation : providedRole.getInterfaceType().getSignatures()) {
            this.addGASTBehaviourToPrimitiveComponent(component, operation);
        }
    }

    private void addGASTBehaviourToPrimitiveComponent(PrimitiveComponent component, Operation operation) {
        MethodLevelSourceCodeLink link = this.getMethodLevelSourceCodeLink(operation);
        if (link == null) {
            throw new RuntimeException("Found interface with operations for which no method link exists. This should never happen!");
        }
        link.setComponentType((ComponentType)component);
        this.analysisResult.getSourceCodeDecoratorRepository().getMethodLevelSourceCodeLink().add((Object)link);
        GastBehaviourStub gastBehaviourStub = BehaviourFactory.eINSTANCE.createGastBehaviourStub();
        gastBehaviourStub.setOperation(link.getOperation());
        GASTBehaviour gastBehaviour = qimpressgastFactory.eINSTANCE.createGASTBehaviour();
        component.getOperationBehaviour().add((Object)gastBehaviourStub);
        gastBehaviour.setBlockstatement(link.getFunction().getBody());
        if (gastBehaviour.getBlockstatement() == null || gastBehaviour.getBlockstatement().getStatements().size() == 0) {
            logger.warn((Object)"Empty behaviour added!");
        }
        gastBehaviour.setGastbehaviourstub(gastBehaviourStub);
        this.analysisResult.getGastBehaviourRepository().getGastbehaviour().add((Object)gastBehaviour);
    }

    private MethodLevelSourceCodeLink getMethodLevelSourceCodeLink(Operation operation) {
        for (MethodLevelSourceCodeLink link : this.analysisResult.getSourceCodeDecoratorRepository().getMethodLevelSourceCodeLink()) {
            if (operation != link.getOperation()) continue;
            return link;
        }
        return null;
    }
}

