/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import de.fzi.gast.core.Root;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.Connector;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Port;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;
import eu.qimpress.samm.staticstructure.SubcomponentEndpoint;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.jgrapht.Graph;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.metrics.ClusteringRelation;

public class ConnectorBuilder
extends AbstractBuilder {
    private static final Logger logger = Logger.getLogger(ConnectorBuilder.class);

    public ConnectorBuilder(Root gastModel, SoMoXConfiguration somoxConfiguration, AnalysisResult analysisResult) {
        super(gastModel, somoxConfiguration, analysisResult);
    }

    public void buildAssemblyConnectors(ComponentImplementingClassesLink compositeComponentCandidate, Graph<ComponentImplementingClassesLink, ClusteringRelation> compositeComponentSubgraph) {
        if (!compositeComponentCandidate.isCompositeComponent()) {
            throw new IllegalArgumentException("Add assembly connectors not allowed for primitive components");
        }
        for (ClusteringRelation edge : compositeComponentSubgraph.edgeSet()) {
            this.probeAssemblyConnector((CompositeComponent)compositeComponentCandidate.getComponent(), (ComponentImplementingClassesLink)compositeComponentSubgraph.getEdgeSource((Object)edge), (ComponentImplementingClassesLink)compositeComponentSubgraph.getEdgeTarget((Object)edge));
        }
    }

    private void probeAssemblyConnector(CompositeComponent component, ComponentImplementingClassesLink edgeSource, ComponentImplementingClassesLink edgeTarget) {
        EList requiredRoles = edgeSource.getComponent().getRequired();
        EList providedRoles = edgeTarget.getComponent().getProvided();
        for (InterfacePort requiredRole : requiredRoles) {
            for (InterfacePort providedRole : providedRoles) {
                if (requiredRole.getInterfaceType() != providedRole.getInterfaceType()) continue;
                this.createAssemblyConnector(component, (Port)requiredRole, (Port)providedRole, edgeSource.getComponent(), edgeTarget.getComponent());
            }
        }
    }

    private void createAssemblyConnector(CompositeComponent component, Port requiredPort, Port providedPort, ComponentType source, ComponentType target) {
        logger.debug((Object)("Creating new assembly connector from " + source.getName() + " to " + target.getName()));
        Connector newConnector = StaticstructureFactory.eINSTANCE.createConnector();
        component.getConnector().add((Object)newConnector);
        newConnector.setDocumentation("Assembly Connector");
        SubcomponentEndpoint sourceEndpoint = StaticstructureFactory.eINSTANCE.createSubcomponentEndpoint();
        newConnector.getEndpoints().add((Object)sourceEndpoint);
        SubcomponentEndpoint targetEndpoint = StaticstructureFactory.eINSTANCE.createSubcomponentEndpoint();
        newConnector.getEndpoints().add((Object)targetEndpoint);
        sourceEndpoint.setPort(requiredPort);
        targetEndpoint.setPort(providedPort);
    }
}

