/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.transformations.common.jobs;

import de.uka.ipd.sdq.errorhandling.SeverityEnum;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.OrderPreservingBlackboardCompositeJob;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedRunConfiguration;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.emf.CheckEMFConstraintsJob;
import de.uka.ipd.sdq.workflow.mdsd.oaw.PerformOAWCheckValidation;
import de.uka.ipd.sdq.workflow.mdsd.validation.ModelValidationJob;
import de.uka.ipd.sdq.workflow.mdsd.validation.ShowValidationErrorsJob;
import eu.qimpress.transformations.common.jobs.LoadSAMMIntoBlackboardJob;

public class SAMMValidationJob
extends OrderPreservingBlackboardCompositeJob<MDSDBlackboard> {
    public static final String OAW_CORE_SAMM_CHECK_FILE = "samm";

    public SAMMValidationJob(AbstractWorkflowBasedRunConfiguration configuration, String ... oawCheckFiles) {
        this.setName("Checking PCM model constraints");
        String[] stringArray = oawCheckFiles;
        int n = oawCheckFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String oawCheckFile = stringArray[n2];
            this.addJob((IJob)new PerformOAWCheckValidation("eu.qimpress.samm.partition", oawCheckFile, LoadSAMMIntoBlackboardJob.SAMM_EPACKAGES));
            ++n2;
        }
        this.addJob((IJob)new CheckEMFConstraintsJob(SeverityEnum.ERROR, "eu.qimpress.samm.partition"));
        this.addJob((IJob)new ShowValidationErrorsJob(configuration, (ModelValidationJob[])this.toArray(new ModelValidationJob[0])));
    }
}

