/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.transformations.common.jobs;

import ResultModel.ResultModelPackage;
import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EPackage;

public class PrepareResultsBlackboardPartionJob
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger logger = Logger.getLogger(PrepareResultsBlackboardPartionJob.class);
    private static final String JOB_NAME = "Prepare Results Blackboard Partions";
    public static final String PARTITION_ID = "eu.qimpress.results.partition";
    public static final EPackage[] RESULTS_EPACKAGES = new EPackage[]{ResultModelPackage.eINSTANCE};
    private MDSDBlackboard blackboard;

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        logger.debug((Object)"Creating Results Model Partition");
        ResourceSetPartition myPartion = new ResourceSetPartition();
        this.blackboard.addPartition(PARTITION_ID, (Object)myPartion);
        logger.debug((Object)"Initialising Results EPackages");
        myPartion.initialiseResourceSetEPackages(RESULTS_EPACKAGES);
    }

    public String getName() {
        return JOB_NAME;
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
        this.blackboard.removePartition("eu.qimpress.samm.partition");
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

