/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.transformations.common.jobs;

import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.transformations.common.jobs.LoadSAMMIntoBlackboardJob;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;

public class LoadSAMMAlternativeJob
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger logger = Logger.getLogger(LoadSAMMIntoBlackboardJob.class);
    private MDSDBlackboard blackboard;
    private IQAlternative alternative;
    public static final String[] SAMM_EXTENSIONS = new String[]{"samm_repository", "samm_servicearchitecturemodel", "samm_qosannotation", "samm_seff", "samm_hardware", "samm_targetenvironment", "samm_usagemodel", "samm_resultmodel"};

    public LoadSAMMAlternativeJob(IQAlternative alternative) {
        this.alternative = alternative;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ResourceSetPartition sammPartition = (ResourceSetPartition)this.blackboard.getPartition("eu.qimpress.samm.partition");
        logger.info((Object)"Loading SAMM Model Files");
        IQModel[] elements = this.alternative.getModels();
        String[] stringArray = SAMM_EXTENSIONS;
        int n = SAMM_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            URI location = LoadSAMMAlternativeJob.getResourceURI(elements, extension);
            logger.debug((Object)("Loading SAM model file " + location));
            sammPartition.loadModel(location);
            ++n2;
        }
        sammPartition.resolveAllProxies();
    }

    public String getName() {
        return "Loading model files of SAMM Alternative";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    public static URI getResourceURI(IQModel[] elements, String fileextension) {
        IQModel[] iQModelArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IQModel elem = iQModelArray[n2];
            URI location = LoadSAMMAlternativeJob.getURIForQIElement((IQElement)elem);
            if (location.fileExtension().equals(fileextension)) {
                return location;
            }
            ++n2;
        }
        throw new RuntimeException("Unable to find file with extension " + fileextension + ". " + "Check  SAMM alternative for completeness.");
    }

    public static URI getURIForQIElement(IQElement elem) {
        URI location = URI.createURI((String)elem.getCorrespondingResource().getLocationURI().toString());
        return location;
    }
}

