/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.reverseengineering.ui.launch;

import de.fzi.sissy.gastimporter.jobs.GASTModelImporterJob;
import de.fzi.sissy.main.jobs.SISSyJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.OrderPreservingCompositeJob;
import de.uka.ipd.sdq.workflow.Workflow;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractConfigBuilderBasedLaunchConfigurationDelegate;
import de.uka.ipd.sdq.workflow.launchconfig.LoggerAppenderStruct;
import de.uka.ipd.sdq.workflow.launchconfig.configbuilder.AbstractUIBasedConfigurationBuilder;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.reverseengineering.gast2seff.jobs.GAST2SEFFJob;
import eu.qimpress.reverseengineering.ui.jobs.PrintInformationJob;
import eu.qimpress.reverseengineering.ui.launch.ReverseEngineeringConfiguration;
import eu.qimpress.reverseengineering.ui.launch.configbuilder.UIBasedReverseEngineeringConfigurationBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.somox.analyzer.simplemodelanalyzer.jobs.SimpleModelAnalyzerJob;
import org.somox.common.SoMoXProjectPreferences;

public class ReverseEngineeringWorkflowLaunchDelegate
extends AbstractConfigBuilderBasedLaunchConfigurationDelegate<ReverseEngineeringConfiguration, Workflow>
implements ILaunchConfigurationDelegate {
    private static final String LOG_PATTERN = "%-5p: %m\n";

    protected IJob createWorkflowJob(ReverseEngineeringConfiguration config, ILaunch launch) throws CoreException {
        int step = 0;
        OrderPreservingCompositeJob reverseEngineeringToolchainJob = new OrderPreservingCompositeJob();
        this.configureSISSyJob(config, reverseEngineeringToolchainJob, ++step);
        this.configureSISSy2GAST(config, reverseEngineeringToolchainJob, ++step);
        this.configureSoMoX(config, reverseEngineeringToolchainJob, ++step);
        this.configureGAST2SEFF(config, reverseEngineeringToolchainJob, ++step);
        return reverseEngineeringToolchainJob;
    }

    protected AbstractUIBasedConfigurationBuilder<ReverseEngineeringConfiguration> getConfigurationBuilder(ILaunchConfiguration configuration) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(configuration.getAttributes());
        String somoxProjectName = this.getSomoxProjectName(attributes);
        String guid = (String)attributes.get("eu.qimpress.reverseengineering.alternativeselection");
        attributes.put(SoMoXProjectPreferences.SOMOX_PROJECT_NAME, somoxProjectName);
        attributes.put(SoMoXProjectPreferences.SOMOX_ANALYZER_INPUT_FILE, String.valueOf(somoxProjectName) + "/alternatives/" + guid + "/gastmodel.gast");
        return new UIBasedReverseEngineeringConfigurationBuilder(attributes);
    }

    private String getSomoxProjectName(Map<String, Object> attributes) {
        String guid = (String)attributes.get("eu.qimpress.reverseengineering.alternativeselection");
        if (guid != null) {
            IQElement alternative;
            IQApplicationModel model = QImpressApplicationModelManager.getManager().getQAppModel();
            IQElement current = alternative = model.getElementByID(guid);
            while (current.getElementType() != IQElement.ElementType.Q_PROJECT) {
                current = current.getParent();
            }
            IQProject targetProject = (IQProject)current;
            return targetProject.getCorrespondingResource().getName();
        }
        return null;
    }

    protected ArrayList<LoggerAppenderStruct> setupLogging(Level logLevel) throws CoreException {
        ArrayList<LoggerAppenderStruct> loggerList = new ArrayList<LoggerAppenderStruct>();
        loggerList.add(this.setupLogger("de.uka.ipd.sdq.workflow", logLevel, LOG_PATTERN));
        loggerList.add(this.setupLogger("de.fzi.sissy2gast", logLevel, LOG_PATTERN));
        loggerList.add(this.setupLogger("de.fzi.sissy", logLevel, LOG_PATTERN));
        loggerList.add(this.setupLogger("eu.qimpress", logLevel, LOG_PATTERN));
        loggerList.add(this.setupLogger("org.somox", logLevel, LOG_PATTERN));
        return loggerList;
    }

    private void configureGAST2SEFF(ReverseEngineeringConfiguration config, OrderPreservingCompositeJob reverseEngineeringToolchainJob, int step) throws CoreException {
        reverseEngineeringToolchainJob.add((IJob)new PrintInformationJob(this.createStepInfo(step, "Running GAST2SEFF to create behaviours")));
        reverseEngineeringToolchainJob.add((IJob)new GAST2SEFFJob(URI.createFileURI((String)(String.valueOf(config.getWorkingDirectory()) + "/internal_architecture_model.samm_repository"))));
    }

    private void configureSoMoX(ReverseEngineeringConfiguration config, OrderPreservingCompositeJob reverseEngineeringToolchainJob, int step) throws CoreException {
        reverseEngineeringToolchainJob.add((IJob)new PrintInformationJob(this.createStepInfo(step, "Running SoMoX to extract components")));
        reverseEngineeringToolchainJob.add((IJob)new SimpleModelAnalyzerJob(config.getSomoxConfiguration()));
    }

    private void configureSISSy2GAST(ReverseEngineeringConfiguration config, OrderPreservingCompositeJob reverseEngineeringToolchainJob, int step) throws CoreException {
        reverseEngineeringToolchainJob.add((IJob)new PrintInformationJob(this.createStepInfo(step, "Running SISSy2GAST")));
        reverseEngineeringToolchainJob.add((IJob)new GASTModelImporterJob(config.getSissy2GASTConfiguration()));
    }

    private void configureSISSyJob(ReverseEngineeringConfiguration config, OrderPreservingCompositeJob reverseEngineeringToolchainJob, int step) throws CoreException {
        reverseEngineeringToolchainJob.add((IJob)new PrintInformationJob(this.createStepInfo(step, "Running SISSy")));
        reverseEngineeringToolchainJob.add((IJob)new SISSyJob(config.getSissyConfiguration()));
    }

    private String[] createStepInfo(int step, String msg) {
        return new String[]{"----------------------------------------------------", "Step " + step + ". " + msg, "----------------------------------------------------"};
    }
}

