/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.text.highlighting;

import eu.qimpress.identifier.Identifier;
import eu.qimpress.samm.core.NamedEntity;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.LeafNode;
import org.eclipse.xtext.parsetree.NodeAdapter;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.common.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.common.editor.syntaxcoloring.ISemanticHighlightingCalculator;

public class EdificeSemanticHighlightingCalculator
implements ISemanticHighlightingCalculator {
    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        if (resource == null) {
            return;
        }
        List content = EcoreUtil2.eAllContentsAsList((Resource)resource);
        List elementsWithId = EcoreUtil2.typeSelect((List)content, Identifier.class);
        this.markFeature(elementsWithId, "id", "IDFeature", acceptor);
        List elementsWithName = EcoreUtil2.typeSelect((List)content, NamedEntity.class);
        this.markFeature(elementsWithName, "name", "NameFeature", acceptor);
        Iterable allNodes = NodeUtil.getAllContents((CompositeNode)resource.getParseResult().getRootNode());
        for (AbstractNode abstractNode : allNodes) {
            if (!(abstractNode.getGrammarElement() instanceof CrossReference)) continue;
            acceptor.addPosition(abstractNode.getOffset(), abstractNode.getLength(), new String[]{"CrossReference"});
        }
    }

    protected void markFeature(Collection<? extends EObject> elements, String featureName, String highlightConfigID, IHighlightedPositionAcceptor acceptor) {
        for (EObject eObject : elements) {
            LeafNode node = this.getFirstFeatureNode(eObject, featureName);
            if (node == null) continue;
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{highlightConfigID});
        }
    }

    protected LeafNode getFirstFeatureNode(EObject semantic, String feature) {
        CompositeNode node;
        NodeAdapter adapter = NodeUtil.getNodeAdapter((EObject)semantic);
        if (adapter != null && (node = adapter.getParserNode()) != null) {
            if (feature == null) {
                return null;
            }
            for (AbstractNode child : node.getChildren()) {
                if (!(child instanceof LeafNode) || !feature.equals(((LeafNode)child).getFeature())) continue;
                return (LeafNode)child;
            }
        }
        return null;
    }
}

