/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.operations;

import ResultModel.ResultModelFactory;
import ResultModel.ResultRepository;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class InitializeQImpressProjectOperation
extends WorkspaceModifyOperation {
    private static final Logger logger = Logger.getLogger(InitializeQImpressProjectOperation.class);
    private IProject project;

    public InitializeQImpressProjectOperation(IProject project) {
        this.project = project;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            try {
                this.createCommonInfrastructure(this.project);
            }
            catch (Exception e) {
                logger.error((Object)("Cannot setup Q-ImPrESS nature for project " + this.project), (Throwable)e);
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void createCommonInfrastructure(IProject project) throws RepositoryException {
        IQProject qProject = QImpressApplicationModelManager.getManager().getQAppModel().getQProject(project);
        IQRepository qRepository = qProject.getRepository();
        boolean foundGlobalAlternative = false;
        boolean foundOtherAlternative = false;
        IQAlternative[] iQAlternativeArray = qRepository.listTopLevelAlternatives();
        int n = iQAlternativeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IQAlternative iqAlternative = iQAlternativeArray[n2];
            String alternativeName = iqAlternative.getInfo().getDescription();
            if ("global alternative".equals(alternativeName)) {
                foundGlobalAlternative = true;
                logger.info((Object)"There is already a global alternative present in the project");
            } else {
                foundOtherAlternative = true;
                logger.info((Object)"There is already an alternative present in the project that can be used as a main alternative");
            }
            ++n2;
        }
        if (!foundOtherAlternative) {
            qRepository.createAlternative("main alternative");
        }
        if (!foundGlobalAlternative) {
            qRepository.createAlternative("global alternative", "0");
        }
        IQModel resultModel = qRepository.getResultModel();
        resultModel.getTopLevelEObject(ResultRepository.class, ResultModelFactory.eINSTANCE.getResultModelPackage().getResultRepository());
        resultModel.save();
    }
}

