/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.operations;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CreateQAlternativeUIOperation
extends WorkspaceModifyOperation {
    private static final Logger logger = Logger.getLogger(CreateQAlternativeUIOperation.class);
    String alternativeName;
    Object alternativeParent;

    public CreateQAlternativeUIOperation(String alternativeName, Object alternativeParent) {
        this.alternativeName = alternativeName;
        this.alternativeParent = alternativeParent;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            try {
                IQAlternative qAlternative = null;
                if (this.alternativeParent instanceof IQAlternative) {
                    qAlternative = this.createAlternative(this.alternativeName, (IQAlternative)this.alternativeParent);
                } else if (this.alternativeParent instanceof IQRepository) {
                    qAlternative = this.createAlternative(this.alternativeName, (IQRepository)this.alternativeParent);
                } else if (this.alternativeParent instanceof IProject) {
                    qAlternative = this.createAlternative(this.alternativeName, (IProject)this.alternativeParent);
                }
                this.fireUpdates(qAlternative);
            }
            catch (Exception e) {
                logger.error((Object)"Cannot create new alternative", (Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private IQAlternative createAlternative(String alternativeName, IProject project) throws RepositoryException {
        IQProject qProject = QImpressApplicationModelManager.getManager().getQAppModel().getQProject(project);
        if (qProject != null && qProject.getRepository() != null) {
            return this.createAlternative(alternativeName, qProject.getRepository());
        }
        return null;
    }

    private IQAlternative createAlternative(String alternativeName, IQRepository repo) throws RepositoryException {
        IQAlternative qAlt = repo.createAlternative(alternativeName);
        return qAlt;
    }

    private IQAlternative createAlternative(String alternativeName, IQAlternative alt) throws RepositoryException {
        IQRepository repo = alt.getRepository();
        IQAlternative qAlt = repo.createAlternative(alt, alternativeName);
        return qAlt;
    }

    private void fireUpdates(IQAlternative qAlt) {
        IQApplicationModel appModel = QImpressApplicationModelManager.getManager().getQAppModel();
        appModel.fireAlternativeCreated(qAlt);
        appModel.fireRefresh();
    }
}

