/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.internal.model;

import eu.qimpress.ide.backbone.core.internal.model.QDirectoryRepositoryImpl;
import eu.qimpress.ide.backbone.core.internal.model.QElement;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class QProjectImpl
extends QElement
implements IQProject {
    private IProject project;
    private IQRepository defaultRepository;
    private Map<IFolder, IQRepository> otherRepositories = new HashMap<IFolder, IQRepository>();

    public QProjectImpl(IProject project, IQApplicationModel qApplicationModel) {
        super(qApplicationModel);
        this.project = project;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IResource getCorrespondingResource() {
        return this.project;
    }

    @Override
    public IQElement.ElementType getElementType() {
        return IQElement.ElementType.Q_PROJECT;
    }

    @Override
    public IQElement[] getChildren() {
        return new IQElement[]{this.defaultRepository};
    }

    @Override
    public IQRepository getRepository() throws RepositoryException {
        if (this.defaultRepository == null) {
            IFolder defaultRepoFolder = this.project.getFolder("alternatives");
            this.defaultRepository = new QDirectoryRepositoryImpl(this, defaultRepoFolder);
        }
        return this.defaultRepository;
    }

    @Override
    public IQRepository getRepository(IFolder location) throws RepositoryException {
        IQRepository ret = this.otherRepositories.get(location);
        if (ret == null) {
            ret = new QDirectoryRepositoryImpl(this, location);
            this.otherRepositories.put(location, ret);
        }
        return ret;
    }

    public Object getAdapter(Class adapter) {
        if (IWorkbenchAdapter.class.equals((Object)adapter)) {
            return this.project.getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }
}

