/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.internal.model;

import ResultModel.AlternativeEvaluation;
import ResultModel.ResultModelFactory;
import ResultModel.ResultRepository;
import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.internal.model.ISupportSaveable;
import eu.qimpress.ide.backbone.core.internal.model.QAlternativeImpl;
import eu.qimpress.ide.backbone.core.internal.model.QAlternativeInfoImpl;
import eu.qimpress.ide.backbone.core.internal.model.QElement;
import eu.qimpress.ide.backbone.core.internal.model.QModelImpl;
import eu.qimpress.ide.backbone.core.internal.model.QRepositoryParam;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQAlternativeInfo;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.ISaveable;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.neodatis.odb.ODB;
import org.neodatis.odb.ODBFactory;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.criteria.ICriterion;
import org.neodatis.odb.core.query.criteria.Where;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;

public class QDirectoryRepositoryImpl
extends QElement
implements IQRepository,
ISupportSaveable {
    static final Logger logger = Logger.getLogger(QDirectoryRepositoryImpl.class);
    public static final String DEFAULT_REPOSITORY_LOCATION = "alternatives";
    static final String DEFAULT_REPOSITORY_DB_LOCATION = ".db";
    private IFolder directory;
    private IQProject qProject;
    private ODB odb;
    private boolean closed = false;

    QDirectoryRepositoryImpl(IQProject project, IFolder directory) throws RepositoryException {
        super(project);
        this.qProject = project;
        if (!directory.exists()) {
            try {
                directory.create(true, true, null);
            }
            catch (CoreException e) {
                throw new RepositoryException("Repository directory does not exists and cannot be created.", e);
            }
            logger.info((Object)"Directory created.");
        }
        this.directory = directory;
        try {
            String filename = directory.getLocation().append(DEFAULT_REPOSITORY_DB_LOCATION).toOSString();
            this.odb = ODBFactory.open((String)filename);
        }
        catch (Exception ex) {
            throw new RepositoryException("Database cannot be opened.", ex);
        }
    }

    @Override
    public IQAlternative[] listAllAlternatives() throws RepositoryException {
        if (this.closed) {
            throw new IllegalStateException("Repository is closed.");
        }
        Objects obs = this.odb.getObjects(QAlternativeInfoImpl.class);
        return this.updateRetrievedAlternatives((Objects<QAlternativeInfoImpl>)obs, null);
    }

    @Override
    public IQAlternative[] listTopLevelAlternatives() throws RepositoryException {
        if (this.closed) {
            throw new IllegalStateException("Repository is closed.");
        }
        CriteriaQuery q = new CriteriaQuery(QAlternativeInfoImpl.class, (ICriterion)Where.and().add(Where.isNull((String)"parent")).add((ICriterion)Where.not((ICriterion)Where.equal((String)"id", (Object)"0"))));
        Objects obs = this.odb.getObjects((IQuery)q);
        return this.updateRetrievedAlternatives((Objects<QAlternativeInfoImpl>)obs, null);
    }

    @Override
    public IQAlternative getAlternative(String id) throws RepositoryException {
        if (this.closed) {
            throw new IllegalStateException("Repository is closed.");
        }
        CriteriaQuery q = new CriteriaQuery(QAlternativeInfoImpl.class, Where.equal((String)"id", (Object)id));
        Objects obs = this.odb.getObjects((IQuery)q);
        IQAlternative[] alts = this.updateRetrievedAlternatives((Objects<QAlternativeInfoImpl>)obs, null);
        if (alts.length == 0) {
            return null;
        }
        return alts[0];
    }

    @Override
    public IQAlternative[] getChildren(IQAlternative alt) throws RepositoryException {
        CriteriaQuery q = new CriteriaQuery(QAlternativeInfoImpl.class, Where.equal((String)"parentId", (Object)alt.getInfo().getId()));
        Objects obs = this.odb.getObjects((IQuery)q);
        return this.updateRetrievedAlternatives((Objects<QAlternativeInfoImpl>)obs, alt);
    }

    @Override
    public IQAlternative createAlternative(String description) throws RepositoryException {
        return this.createAlternative(null, description, false, null);
    }

    @Override
    public IQAlternative createAlternative(IQAlternative parent, String description) throws RepositoryException {
        return this.createAlternative(parent, description, false);
    }

    @Override
    public IQAlternative createAlternative(IQAlternative parent, String description, boolean noCopy) throws RepositoryException {
        return this.createAlternative(parent, description, noCopy, null);
    }

    @Override
    public IQAlternative createAlternative(String description, String SpecifiedId) throws RepositoryException {
        return this.createAlternative(null, description, false, "0");
    }

    public IQAlternative createAlternative(IQAlternative parent, String description, boolean noCopy, String SpecifiedId) throws RepositoryException {
        if (this.closed) {
            throw new IllegalStateException("Repository is closed.");
        }
        IQAlternativeInfo parentInfo = parent != null ? parent.getInfo() : null;
        QAlternativeInfoImpl alternativeInfo = new QAlternativeInfoImpl(parentInfo, description);
        if (SpecifiedId != null) {
            alternativeInfo = new QAlternativeInfoImpl(parentInfo, description, SpecifiedId);
        }
        QAlternativeImpl alt = new QAlternativeImpl(this, parent, alternativeInfo, noCopy);
        this.odb.store((Object)alternativeInfo);
        this.odb.commit();
        return alt;
    }

    @Override
    public void deleteAlternative(IQAlternative alternative) throws RepositoryException {
        this.deleteAlternative(alternative, false, false);
    }

    @Override
    public void deleteAlternative(IQAlternative alternative, boolean deleteContent, boolean force) throws RepositoryException {
        if (this.closed) {
            throw new IllegalStateException("Repository is closed.");
        }
        IQAlternative[] children = this.getChildren(alternative);
        if (force) {
            IQAlternative[] iQAlternativeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IQAlternative chAlt = iQAlternativeArray[n2];
                this.deleteAlternative(chAlt, deleteContent, force);
                ++n2;
            }
        } else if (children.length != 0) {
            throw new RepositoryException("Cannot be deleted - there are child alternatives");
        }
        this.odb.delete((Object)alternative.getInfo());
        this.odb.commit();
        if (deleteContent) {
            try {
                alternative.getAlternativeFolder().delete(true, false, null);
            }
            catch (CoreException ex) {
                throw new RepositoryException("Cannot delete content of the alternative \"" + alternative.getInfo().getId() + "\"", ex);
            }
        }
    }

    @Override
    public void close() throws RepositoryException {
        if (this.odb != null && !this.odb.isClosed()) {
            try {
                this.odb.close();
                this.odb = null;
            }
            catch (Exception ex) {
                throw new RepositoryException("Database cannot be closed.", ex);
            }
            this.closed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed || this.odb == null || this.odb.isClosed();
    }

    void storeUpdatedAlternative(QAlternativeImpl alt) {
        this.odb.store((Object)alt);
    }

    private IQAlternative[] updateRetrievedAlternatives(Objects<QAlternativeInfoImpl> obs, IQAlternative parentAlternative) throws RepositoryException {
        IQAlternative[] alternatives = new IQAlternative[obs.size()];
        int i = 0;
        for (QAlternativeInfoImpl ai : obs) {
            alternatives[i++] = new QAlternativeImpl(this, parentAlternative, ai, false);
        }
        return alternatives;
    }

    @Override
    public IQElement.ElementType getElementType() {
        return IQElement.ElementType.Q_REPOSITORY;
    }

    @Override
    public IResource getCorrespondingResource() {
        return this.getRepositoryFolder();
    }

    @Override
    public IFolder getRepositoryFolder() {
        return this.directory;
    }

    @Override
    public IQAlternative getDefaultAlternative() throws RepositoryException {
        IQAlternative[] alternatives = this.listAllAlternatives();
        IQAlternative result = null;
        IQAlternative[] iQAlternativeArray = alternatives;
        int n = alternatives.length;
        int n2 = 0;
        while (n2 < n) {
            IQAlternative alternative = iQAlternativeArray[n2];
            if (alternative.getInfo().isDefault()) {
                result = alternative;
                break;
            }
            ++n2;
        }
        if (result == null && alternatives.length > 0) {
            result = alternatives[0];
            result.getInfo().setDefault(true);
        }
        if (result != null) {
            ((QElement)((Object)result)).parent = this.parent;
        }
        return result;
    }

    @Override
    public IQAlternative getGlobalAlternative() throws RepositoryException {
        IQAlternative[] alternatives;
        IQAlternative[] iQAlternativeArray = alternatives = this.listAllAlternatives();
        int n = alternatives.length;
        int n2 = 0;
        while (n2 < n) {
            IQAlternative alternative = iQAlternativeArray[n2];
            if (QImpressCore.isGlobalAlternative(alternative)) {
                return alternative;
            }
            ++n2;
        }
        throw new RepositoryException("Global alternative not found, there should always be a single global alternative in a project");
    }

    @Override
    public void save(ISaveable o) throws RepositoryException {
        this.odb.store((Object)o);
        this.odb.commit();
    }

    @Override
    public IQProject getQProject() {
        return (IQProject)this.getParent();
    }

    @Override
    public boolean containsKey(String key) {
        CriteriaQuery query = new CriteriaQuery(QRepositoryParam.class, Where.equal((String)"key", (Object)key));
        return this.odb.count(query).compareTo(new BigInteger("0")) > 0;
    }

    @Override
    public Object getParameter(String key) {
        CriteriaQuery query = new CriteriaQuery(QRepositoryParam.class, Where.equal((String)"key", (Object)key));
        Objects objects = this.odb.getObjects((IQuery)query);
        if (objects.size() == 0) {
            return null;
        }
        return ((QRepositoryParam)objects.getFirst()).value;
    }

    @Override
    public void setParameter(String key, Object value) {
        CriteriaQuery query = new CriteriaQuery(QRepositoryParam.class, Where.equal((String)"key", (Object)key));
        Objects objects = this.odb.getObjects((IQuery)query);
        if (objects.size() == 0) {
            if (value != null) {
                this.odb.store((Object)new QRepositoryParam(key, value));
            }
        } else {
            QRepositoryParam param = (QRepositoryParam)objects.getFirst();
            if (value == null) {
                this.odb.delete((Object)param);
            } else {
                param.value = value;
                this.odb.store((Object)param);
            }
        }
        this.odb.commit();
    }

    @Override
    public AlternativeEvaluation createAlternativeEvaluation() throws RepositoryException {
        AlternativeEvaluation newAlternativeEvaluation = ResultModelFactory.eINSTANCE.createAlternativeEvaluation();
        this.getResultRepository().getAnalysisRuns().add((Object)newAlternativeEvaluation);
        return newAlternativeEvaluation;
    }

    @Override
    public AlternativeEvaluation createAlternativeEvaluation(String alternativeId) throws RepositoryException {
        AlternativeEvaluation newAltEval = this.createAlternativeEvaluation();
        newAltEval.setAlternativeId(alternativeId);
        return newAltEval;
    }

    @Override
    public List<AlternativeEvaluation> getAllAlternativeEvaluations() throws RepositoryException {
        return this.getResultRepository().getAnalysisRuns();
    }

    @Override
    public List<AlternativeEvaluation> getAlternativeEvaluationByAlternativeId(String id) throws RepositoryException {
        LinkedList<AlternativeEvaluation> listFound = new LinkedList<AlternativeEvaluation>();
        for (AlternativeEvaluation altEval : this.getAllAlternativeEvaluations()) {
            if (!id.equals(altEval.getAlternativeId())) continue;
            listFound.add(altEval);
        }
        return listFound;
    }

    @Override
    public IQModel getResultModel() throws RepositoryException {
        IFile resultModelFile = this.getResultRepositoryFile();
        QModelImpl qModel = new QModelImpl(resultModelFile, this.getGlobalAlternative());
        return qModel;
    }

    @Override
    public ResultRepository getResultRepository() throws RepositoryException {
        IQModel resultModel = this.getResultModel();
        ResultRepository resultRepository = resultModel.getTopLevelEObject(ResultRepository.class, ResultModelFactory.eINSTANCE.getResultModelPackage().getResultRepository());
        return resultRepository;
    }

    protected IFile getResultRepositoryFile() {
        try {
            IFolder defAlternativeFolder = this.qProject.getRepository().getGlobalAlternative().getAlternativeFolder();
            return defAlternativeFolder.getFile("global_result_repository.samm_resultmodel");
        }
        catch (Exception exception) {
            return null;
        }
    }
}

